clearvars
clc
addpath 'helper_functions/'

Lmin = 5;
Lmax = 25;
nL = 12;
nR = 3*nL;
nn = 3;
ntries = 100;

Lval = round(exp(linspace(log(Lmin),log(Lmax),nL)))
Rval = round(exp(3*linspace(log(Lmin),log(Lmax),nR)-log(12)));
nval = 2:4;

avgG = zeros(nR, nL, nn);
tic
for i=1:nL
    L = Lval(i);
    
    for j=1:nR
        R = Rval(j);

        Gijsum = zeros(nn,1);
        
        for tries=1:ntries
            A = randn(L, R);
            A = A./ vecnorm(A);
            G = A'*A;
            for k = 1:nn
                n = nval(k);
                if R <= nchoosek(L + n - 1, n)
                    % Use eigs to calculate smallest eigenvalue
                    Gijsum(k) = Gijsum(k) + eigs(G.^n,1,'smallestabs');
                end
            end
        end
        
        avgG(j,i, :) = Gijsum / ntries;
        
    end
end

toc
clear B G
save results/grammian.mat
