function [] = test_SPM_deflation(L, R, n, ninner, refine)

addpath 'helper_functions'

tic

% D and K

nn = 4;

if nargin < 4
    ninner = 100;
end
if nargin < 5
    refine = false;
end
% Noise levels
vecnoise = 10.^linspace(-6, -3, nn);
% Number of iterations


err_all = zeros(R, nn, ninner);
    
for iter=1:nn
    
    noise = vecnoise(iter)
    
    for i=1:ninner
        % Generate A
        A_true = randn(L, R);
        A_true = A_true./vecnorm(A_true); 
        lambda_true = (.5 + 1.5 * rand(1,R)) * sqrt(L^n / R);

        % Generate the tensor using A_true
        T = generate_lowrank_tensor(A_true, lambda_true, n);

        % Add entrywise noise
        T_noise = (noise * sqrt(factorial(n))) * symmetrize_tensor(randn(L*ones(1,n)));
        T = T + T_noise;
        
        % Run SPM
        [A_est, lambda] = subspace_power_method(T, L, n, R, ...
                    'ntries', 3, 'maxiter', 10000, 'gradtol', 1e-12,...
                    'refine', refine);

        % The SPM algorithm store the sucessive obtained
        % a_i in reverse order
        A_est = A_est(:, R:-1:1);

        % Compute error
        [~, I] = max(abs(A_est' * A_true), [], 2);
        s = 2 * (sum(A_est .* A_true(:, I)) > 0) - 1;
        err_all(:, iter, i) = vecnorm(A_est - s.* A_true(:, I));
    end
    
end

% These occupy too much space
clear T T_noise

err = mean(err_all, 3);
err_std = std(err_all, 0, 3);

totaltime = toc

if refine r = 'r'; else r = ''; end

save(sprintf('results/deflation_L%dR%dn%d%s.mat', L, R, n, r))

end






