clearvars
clc
addpath 'helper_functions/'

tic

ntries = 10000;
opts.SYM = true;
opts.POSDEF = true;

nL = 10;
n = 2;
% L is approximately equally space in logscale
Lval = round(exp(linspace(log(10), log(40),nL)));
Rval = round([3*Lval; Lval.^1.5; Lval.^2/3])

results = zeros([size(Rval), ntries]);

for iter=1:nL
    
    L = Lval(iter)
    
    for k=1:size(Rval,1)
        
        R = Rval(k, iter);
        avg = 0;

        for tries = 1:ntries
            % Generate A
            A = randn(L, R);
            A = A./vecnorm(A);
            
            % Generate x
            x = randn(L,1);
            x = x/norm(x);
            
            % Compute F_A(x) as given by Lemma 3
            Axn = (x'*A)'.^n;
            GAx = linsolve((A' * A).^n, Axn, opts);

            results(k, iter, tries) = Axn' * GAx;

        end                   
    end
    
end

avg_results = mean(results, 3);
std_results = std(results, 0, 3);

totaltime = toc

loglog(Lval, [avg_results; 2*Rval./Lval.^2])

save results/SPM_expected_value.mat

