function [hp, hf] = error_shaded(x, y, varargin)

x = x(:);

[b, a] = size(y);

assert(b == length(x), 'y wrong format');

for arg=varargin
    assert(size(arg{1},1) == b, 'err wrong format');
    assert(a == size(arg{1},2), 'y and err diff num rows');
end

if nargin<4
    err = varargin{1};
    err_up = y + err;
    err_down = y - err;
else
    err_up = varargin{1};
    err_down = varargin{2};
end

hp = plot(x, y);
hold on
br = b:-1:1;
for i = 1:a
    hf(i) = patch([x; x(br)]', [err_up(:, i);...
            err_down(br, i)] , hp(i).Color);
    hf(i).EdgeColor = 'none';
    hf(i).FaceAlpha = 0.3;
end
hold off

set(gca, 'Children', flipud(get(gca, 'Children')) )

end