clearvars
clc
close all
addpath 'helper_functions'
load results/grammian.mat

hf = gcf;
hf.Position = [100 100 1000 250];
for k = 1:nn
    ax = subplot('Position', [0.31 * (k-1) + 0.05, 0.15, ...
                              0.24 + .06*(k==3), 0.75]);
    contourf(ax, Lval, Rval, avgG(:,:, k) ,linspace(0,1,20))
    set(ax,'XScale','log','YScale','log', 'FontSize',10,...
            'TickLabelInterpreter','latex')
    n = nval(k);
    L1 = max(Lval(1),(Rval(1)*factorial(n))^(1/n));
    L2 = min(Lval(end),(Rval(end)*factorial(n))^(1/n));
    hold on
    plot(ax, [L1, L2],[L1, L2].^nval(k) / factorial(nval(k)),...
    'LineStyle', '--', 'LineWidth', 2,'Color', 'red')
    xlabel('$D$','Interpreter','latex');
    ylabel('$K$','Interpreter','latex');
    title(sprintf('$n=%d$',n),'Interpreter','latex');
    legk = sprintf('$K = \\frac1{%d} D^%d$', factorial(n), n);
    hl = legend(ax,{'', legk},...
    'Interpreter','latex','Location','northwest','FontSize',10);
end
c = colorbar;
c.Label.String = '$\sigma_K$';
c.Label.Interpreter = 'latex';
c.Label.Position = [0.48 .96];
c.Label.Rotation = 0;
c.Label.FontSize = 10;
pdfprint(sprintf('results/Gsmalleig',n), hf)