clearvars
clc
close all
addpath 'helper_functions'


%err_LR_PM = squeeze(err_all_LR(:, :, 1, :));
%err_LR_SPM = squeeze(err_all_LR(:, :, 2, :));

%% L test

load("results/PM_vs_SPM_L_2.mat")

err_LR_PM(:,:) = err_LR(:, :, 1);
err_LR_SPM(:,:) = err_LR(:, :, 2);
err_std_LR_PM(:,:) = err_std_LR(:, :, 1);
err_std_LR_SPM(:,:) = err_std_LR(:, :, 2);

hf = figure(1);
hf.Position = [100 100 800 200];

ax = subplot('Position', [0.09 0.2, 0.135, 0.7]);

[hpl, hpa] = error_shaded(vecL, err_LR_PM, err_std_LR_PM);
hpl(2).LineStyle = '--';
hpl(3).LineStyle = '-.';
hpl(3).Color = [0 .5 0];
hpa(3).FaceColor = [0 .5 0];
for hplk=hpl.'
    hplk.LineWidth = 1.5;
end
for hpai=hpa
    hpai.FaceAlpha = 0.25;
    hpai.YData = max(hpai.YData, 1e-10);
end

xlabel('$D$','Interpreter','latex');
ylabel('avg $\min_i\|x_*-s a_i\|_2$','Interpreter','latex');
title('PM $(n=2)$','Interpreter','latex')
legk = {'$K = 3 D$', '$K = D^{\frac32}$', '$K = \frac13 D^2$'};
ylim([5e-2, 1]);
hl(1) = legend(ax, hpl, legk, 'Interpreter','latex','Location','best','FontSize',10);
hl(1).Position = [0.8610    0.4008    0.1321    0.2734];
set(ax,'XScale','log','YScale','log', 'FontSize',10,...
        'TickLabelInterpreter','latex')
    
ax = subplot('Position', [0.295, 0.2, 0.135, 0.7]);

[hpl, hpa] = error_shaded(vecL, err_LR_SPM, err_std_LR_SPM);
hpl(2).LineStyle = '--';
hpl(3).LineStyle = '-.';
hpl(3).Color = [0 .5 0];
hpa(3).FaceColor = [0 .5 0];
for hplk=hpl.'
    hplk.LineWidth = 1.5;
end
for hpai=hpa
    hpai.FaceAlpha = 0.2;
    hpai.YData = max(hpai.YData, 1e-16);
end
xlabel('$D$','Interpreter','latex');
%title('\textbf{nSPM-P} $(n=2)$','Interpreter','latex')
title('SPM $(n=2)$','Interpreter','latex')
ylim([1e-15, 1e-10]);
%hl(1) = legend(ax, hpl, legk, 'Interpreter','latex','Location','best','FontSize',10);
set(ax,'XScale','log','YScale','log', 'FontSize',10,...
        'TickLabelInterpreter','latex')
for n=3:4
    load(sprintf("results/PM_vs_SPM_L_%d.mat", n))

    ax = subplot('Position', [0.09 + (n-1)*0.205, 0.2, 0.135, 0.7]);

    err_LR_SPM(:,:) = err_LR(:, :, 2);
    err_std_LR_SPM(:,:) = err_std_LR(:, :, 2);

    [hpl, hpa] = error_shaded(vecL, err_LR_SPM, .5*err_std_LR_SPM);
    hpl(2).LineStyle = '--';
    hpl(3).LineStyle = '-.';
    hpl(3).Color = [0 .5 0];
    hpa(3).FaceColor = [0 .5 0];
    for hplk=hpl.'
        hplk.LineWidth = 1.5;
    end
    for hpai=hpa
        hpai.FaceAlpha = 0.25;
        hpai.YData = max(hpai.YData, 1e-15);
    end
    
    title(sprintf('SPM $(n=%d)$',n),'Interpreter','latex')
    xlabel('$D$','Interpreter','latex');
    ylim([1e-15, 1e-10]);
    set(ax,'XScale','log','YScale','log', 'FontSize',10,...
            'TickLabelInterpreter','latex')

end


%print_plot('results/PM_vs_SPM_L_rebuttal', hf)
pdfprint('results/PM_vs_SPM_L_presentation', hf)

function [] = print_plot(filename, figure)
% Print a figure in pdf (for nice vectorized pictures)
% Solution in https://www.mathworks.com/matlabcentral/answers/12987-how-to-save-a-matlab-graphic-in-a-right-size-pdf

    if ~exist('figure', 'var') || isempty(figure)
        figure = gcf;
    end
    
    set(figure ,'Units','Inches');
    pos = get(figure ,'Position');
    set(figure ,'PaperPositionMode','Auto',...
                'PaperUnits','Inches',...
                'PaperSize',[pos(3), pos(4)]);
    print(figure, filename,'-dpng','-r300');




end
   
