clearvars
clc
close all
addpath 'helper_functions'
load results/func2D.mat

hf = gcf;
hf.Position = [100 100 800 220];
ax = subplot('Position', [0.05, 0.21, 0.35, 0.65]);
p1 = plot(ax, theta, PM_val, 'Linewidth', 1);
p1(1).LineStyle = '--';
p1(3).LineStyle = '-.';
hold on
for k=1:3
    scatter(ax, tmax(k,:), PM_valm(k,:), 12,...
        'MarkerFaceColor', p1(k).Color);
end
xlim([-pi, pi])
xticks([-pi, -pi/2, 0, pi/2, pi])
xticklabels({'$-\pi$','$-\frac{\pi}{2}$','$0$','$\frac{\pi}{2}$','$\pi$'})
xlabel('$\theta$','Interpreter','latex');
title('PM objective','Interpreter','latex');
set(ax,'FontSize',12,'TickLabelInterpreter','latex')
%h_leg = legend(ax,{'$\theta_0 = \frac{\pi}{6}$',...
%           '$\theta_0 = \frac{5\pi}{14}$',...
%           '$\theta_0 = \frac{\pi}{2}$'},...
%    'Interpreter','latex','Location','southwest','FontSize',12);
%h_leg.Position(4) = h_leg.Position(4) * 1.3;


ax = subplot('Position', [0.6 , 0.21, 0.35, 0.65]);
set(ax,'FontSize',12,'TickLabelInterpreter','latex')
p2 = plot(ax, theta, SPM_val, 'Linewidth', 1);
p2(1).LineStyle = '--';
p2(3).LineStyle = '-.';
hold on
for k=1:3
    scatter(ax, tmax(k,:), SPM_valm(k,:), 12,...
        'MarkerFaceColor', p2(k).Color);
end
xlim([-pi, pi])
xticks([-pi, -pi/2, 0, pi/2, pi])
xticklabels({'$-\pi$','$-\frac{\pi}{2}$','$0$','$\frac{\pi}{2}$','$\pi$'})
xlabel('$\theta$','Interpreter','latex');
title('SPM objective','Interpreter','latex', 'FontSize',12);    
set(ax,'FontSize',12,'TickLabelInterpreter','latex')
h_leg = legend(ax,{'$\theta_0 = \frac{\pi}{6}$',...
           '$\theta_0 = \frac{5\pi}{14}$',...
           '$\theta_0 = \frac{\pi}{2}$'},...
    'Interpreter','latex','Location','southwest','FontSize',12);
h_leg.Position = [0.4236, 0.3525, 0.1281, 0.3264];
%h_leg.Position(4) = h_leg.Position(4) * 1.3;
pdfprint('results/PM_vs_SPM_objective', hf)
