clearvars
clc
close all
addpath 'helper_functions'
load results/SPM_expected_value.mat

hf = figure(1);
hf.Position = [100 100 550 250];
ha = gca;
hold off

[hpl, hpa] = error_shaded(Lval, avg_results', std_results');
hpl(3).Color = [0 .7 0];
hpa(3).FaceColor = [0 .7 0];
hold on
ha.ColorOrderIndex = 1;
hpl(4:6) = plot(Lval, 2*Rval./Lval.^2, 'LineStyle', '--');
hpl(6).Color = [0 .7 0];
for hplk=hpl.'
    hplk.LineWidth = 1.5;
end
ylabel('$y$','Interpreter','latex');
xlabel('$D$','Interpreter','latex');

%ylabel('avg $\min_i\|x_*-s a_i\|$','Interpreter','latex');
%title('PM','Interpreter','latex')
legk = {'$K = 3 D$', '$K = D^{\frac32}$', '$K = \frac13 D^2$'};
ylim([0.12, 0.75]);
hl(1) = legend(ha, hpl(1:3), legk, 'Interpreter','latex',...
    'Location','northeastoutside','FontSize',10);
hl(1).Title.String = '$y=\hat E[F_{\mathcal{A}}(x)]$';
hl(1).Title.Interpreter = 'latex';
haaux=axes('position',get(ha,'position'),'visible','off');
hl(2) = legend(haaux, hpl(4:6), legk, 'Interpreter','latex','FontSize',10);
hl(2).Title.String = '$y = 2 K/D^2$';
hl(2).Title.Interpreter = 'latex';
pos = hl(1).Position;
pos(2) = 0.55;
hl(1).Position = pos;
pos(2) = 0.2;
hl(2).Position = pos;
set(ha,'XScale','log','YScale','log', 'FontSize',10,...
        'TickLabelInterpreter','latex')
pos = ha.Position;
pos(3) = pos(3) - 0.16;
pos(1) = pos(1) - 0.05;
ha.Position = pos;

pdfprint('results/SPM_expected_value', hf)