clearvars
clc
addpath 'helper_functions'

% The different theta_0
s = pi*[1/6, 5/14, 1/2];

theta = linspace(-pi, pi, 200);

for i=1:3
    si = s(i);
    A_true = [1, cos(si);...
              0, sin(si)];
    G = A_true'*A_true;
    tmax(i,:) = [-pi, -pi + si, 0, si, pi]';
    X = [cos(theta); sin(theta)];
    AX = A_true' * X;
    
    % These correspond to the true components
    AXm = A_true' * [cos(tmax(i,:)); sin(tmax(i,:))];
    
    % The PM objective (at the plotting points and at the
    % true components)
    PM_val(i,:) = sum(AX.^4);
    PM_valm(i,:) = sum(AXm.^4);
    % The SPM objective (at the plotting points and at the
    % true components)
    SPM_val(i,:) = sum(AX.^2 .* (G.^2 \ AX.^2));
    SPM_valm(i,:) = sum(AXm.^2 .* (G.^2 \ AXm.^2));
end

save results/func2D.mat 
