# Say My Name: a Model’s Bias Discovery Framework -- Bias Naming

Source code implementation for the submission to ICLR2025 with paper ID 11221

## Hardware and Software Requirements

Regarding software:

- The operating system should be a linux distribution
- CUDA 12.1 or greater (may work with 11.8, but we have not tested it, we tested on 12.1)
- An nvidia driver compatible with the CUDA version you are using
- Anaconda or miniconda installed on the system
  - alternatively you can use python venv, but instructions are provided only for conda. If using
    venv, ensure you are using python 3.11.

Regarding hardware:

- An internet connection (possibly fast, since you will have to download about 65+ GB)
- An NVIDIA GPU with at least 48 GiB of VRAM (we tested with more than that, but during captioning the VRAM usage was 44 GiB)
- At least 100 GB of free disk space

Compute time:

- Time is mostly dictated by caption generation, with LLaVA 34B it can take about 2.7 minutes for each image on a A100 GPU, and there are many captions, some of the datasets take up to 10 hours, the smallest datasets usually take at least 2 or 3 hours.

## Setup

First of all you must setup a conda environment:

```
conda create -n naming-biases python=3.11
conda activate naming-biases
conda install poetry
```

Poetry can sometimes give problems if the following environment variable is not
set, run the following commands to avoid any issue. Notice that you can replace
~/.bashrc with your shell configuration file, for example ~/.zshrc for zsh shell.

```
echo "export PYTHON_KEYRING_BACKEND=keyring.backends.null.Keyring" >> ~/.bashrc
source ~/.bashrc
```

Now install the various libraries with this poetry command, which must be
run inside the project's folder (the one that contains main.py).

```
poetry install
```

After this, if you haven't already done it, add to your .bashrc (or similar file) an environment variable called
NAMING_BIASES_DATA_PATH that will point to a path where you want to store all the
data (models, datasets, ecc...), to do so run the following command:

```
# WARNING: change the path to a location that has at least 100 GB of free disk space, use an absolute path

echo "export NAMING_BIASES_DATA_PATH=/path/to/data/naming-biases" >> ~/.bashrc
```

Now run (if you haven't already done it):

```
source ~/.bashrc                       # or similar, like .zshrc if you use zsh
mkdir $NAMING_BIASES_DATA_PATH
mkdir $NAMING_BIASES_DATA_PATH/datasets
```

Next, you should take from the provided supplementary material the folder
"waterbirds_no_bias_toy_example" and place it inside the folder
$NAMING_BIASES_DATA_PATH/datasets.

Finally, inside the project's folder, run this command:

```
python main.py nltk_setup
```

To test if GPUs work you can run this command (inside the main project's folder):

```
python main.py test gpu

# Should print something like this:
#
# CUDA Available: True
# Found GPU device: GPU 0 NAME
# Found GPU device: GPU 1 NAME
# GPU Test successful
```

## Using the command line interface

This project uses google's Fire library for command line parsing, you can find
more information on the syntax here: https://google.github.io/python-fire/guide/.

For now there are 3 main groups of commands (test, datasets, and bias), you can list
the commands in the various groups and their description by doing:

```
python main.py test --help
python main.py datasets --help
python main.py bias --help
```

For each command you can show help information with descritpion of all the
command line arguments, for example:

```
python main.py datasets gen_captions --help
```

The source code for the commands is located in src/commands if you want to check
in more detail what they do and how.

## Reproducing the results

First of all, to reproduce the results using this repository you should first
run the first part of the pipeline, which is in a separate repository. After
doing everything that is descrived in the README of that repository, you
should be able to continue with this one.

To reproduce the results for all datasets you can run (may take days):

```
bash reprod/all.sh
```

If you have already generated the captions for all datasets (either by using the
above command, or in other ways) and want to run (or run again) the bias naming
experiments and the generation of the heatmaps for all datasets, you can run:

```
bash reprod/all-skip-captions.sh
```

The output will be saved inside each dataset's folder inside $NAMING_BIASES_DATA_PATH/datasets.

If your GPU number 0 does not have enough memory, you can change the GPU by using
the CUDA_VISIBLE_DEVICES environment variable like this:

```
CUDA_VISIBLE_DEVICES=1 bash reprod/all.sh
```

If you want to reproduce results only for a few datasets you can run:

```
bash reprod/dataset_name.sh
```

You can find a list of all possible datasets by looking at the contents of the
file reprod/all.sh, which simply lists the above command for all the
datasets.

If you already have caption for a single (or more) dataset, and want to run (or re-run)
all the associated experiments with that dataset excluding caption generation, you can run:

```
bash reprod/dataset_name-skip-captions.sh
```

In this case, you can find all available commands for skipping captions in reprod/all-skip-captions.sh.

If you run the same command twice, the old output will be overridden by the new one.

## Interpreting the results

WARNING: The final filtration step to remove the keywords sharing the same verbal root as the target
is not included in the attached code.

After reproducing all results you will find the following dataset folders inside the $NAMING_BIASES_DATA_PATH/datasets
folder, and each of this folders will contain all the results.

```
bar_mined_bias_exemplars-v2
celeba_mined_bias_exemplars_v5
insects_on_hand_mined_bias_exemplars
waterbirds_mined_bias_exemplars_seed_0
waterbirds_mined_bias_exemplars_vitb16
waterbirds_no_bias_toy_example
insects_on_hand_mined_bias_exemplars_swinv2b
insects_on_hand_mined_bias_exemplars_vitb16
```

Each of these folder will contain as subfolders:

- imgs: this contains all the images with a numeric ID
- *-captions folders: there will be a folder ending with "captions" for each set of captions that were created
  with different models (LLaVA 7B and 34B). Not every dataset will have the captions for all models.
- biases-k-*: contains as subfolders, the folders named from 0 to N-1 where N is the number of classes, inside
  each folder there will be a correctly-classified.txt file, and an incorrectly-classified.txt file that list
  the numeric IDs of the images. In the name of this folder, the number after "k" represents the number of
  medoids used to subsample the correctly classified examples.
- outputs: this folder will contain the final outputs, which may be txt files with the keyword rankings, or
  folders containing heatmaps.
- bias-naming-debug-info: contains some debug information, like the full ranking, and a debug.pkl file which
  contains things like all the distances, etc.

You are mainly concerned by the outputs folder, inside this folder you
will find .txt files with names like "b2v_cap-emb_k-medoid-10_top-k-incor-10.txt", in this case
it is a bias naming run with K-medoids 10 for the correctly classified examples, and by taking the
top 10 incorrectly classified examples (in the order they appear in incorrectly-classified.txt, which
is sorted by a distance metric).

You can also find:

- b2v_generic-prompt_cap-emb_k-medoid-10_top-k-incor-10.txt (a generic prompt version, instead of a dataset specific prompt, note that for the datasets in which only the generic version exists this file will not have "generic-prompt" in the name).
- b2v_llava-7b-cap-emb_k-medoid-10_top-k-incor-10.txt (it indicates that these results were obtained
  using the captions from llava 7b, also here, where only llava 7b was used this will not be reported
  in the name of the file)
- b2v_heatmaps_k-medoid-10_top-k-incor-10_patch-28 (a folder containing heatmaps with patch size 28)

In every case, if you have doubts about how a file or folder in the outputs folder was generated, you can
look at the command inside the reprod folder, in the appropriate file. For example if you dont know which
captioning model was used for "b2v_cap-emb_k-medoid-10_top-k-incor-10.txt" inside the dataset "insects_on_hand_mined_bias_exemplars_swinv2b", you can look at the code in reprod/insects-on-hand-swinv2b-bias-naming.sh
and see the following command:

```
python3 main.py bias name_from_caption_embeddings \
    --dataset_name='insects_on_hand_mined_bias_exemplars_swinv2b' \
    --output_file_name='b2v_cap-emb_k-medoid-10_top-k-incor-10.txt' \
    --model_config_path='config/embedding_models/paraphrase-MiniLM-L12-v2.yml' \
    --caption_folder_name='llava-7b-prompt-v1-captions' \
    --biases_folder_name='biases-k-10' \
    --top_k_incorrectly_classified=10
```

Which has caption_folder_name='llava-7b-prompt-v1-captions', which means that llava 7b was used.
