import os
import fire
import nltk
from pathlib import Path
from src.commands.test_cmd import TestCommands
from src.commands.datasets_cmd import DatasetsCommands
from src.commands.bias_cmd import BiasCommands

DATA_PATH = Path(os.environ['NAMING_BIASES_DATA_PATH'])

os.environ['HF_HOME'] = str(DATA_PATH / 'hf_home')

NLTK_CACHE = str(DATA_PATH / 'nltk_cache')

nltk.data.path.append(NLTK_CACHE)

class Commands:
    def __init__(self) -> None:
        self.test = TestCommands()
        self.datasets = DatasetsCommands()
        self.bias = BiasCommands()
    
    def shell(self) -> None:
        """
        Drops into an interactive shell with some variables already
        configured, including HF_HOME.
        """
        
        import code
        import readline
        import rlcompleter

        vars = globals()
        vars.update(locals())

        readline.set_completer(rlcompleter.Completer(vars).complete)
        readline.parse_and_bind("tab: complete")
        code.InteractiveConsole(vars).interact()
    
    def nltk_setup(self) -> None:
        nltk.download('punkt', download_dir=NLTK_CACHE)
        nltk.download('stopwords', download_dir=NLTK_CACHE)


if __name__ == '__main__':
    fire.Fire(Commands)
