#!/bin/bash

keyword_min_freqs=(0.0 0.10 0.15 0.30 0.45 0.60)

for freq in "${keyword_min_freqs[@]}"; do
  output_file_name="b2v_cap-emb_k-medoid-10_top-k-incor-10-${freq}.txt"
  
  python3 main.py bias name_from_caption_embeddings \
    --dataset_name='waterbirds_mined_bias_exemplars_seed_0' \
    --output_file_name="${output_file_name}" \
    --model_config_path='config/embedding_models/paraphrase-MiniLM-L12-v2.yml' \
    --caption_folder_name='llava-34b-prompt-v1-captions' \
    --biases_folder_name='biases-k-10' \
    --keyword_min_freq=${freq} \
    --top_k_incorrectly_classified=10
done
