import yaml
import os
from sentence_transformers import SentenceTransformer
from pathlib import Path
from src.utils.access_token import HF_TOKEN


def load_embedding_model(
        config_path: Path | str,
        need_image_emb: bool,
        need_text_emb: bool
    ) -> SentenceTransformer:

    with open(config_path, 'r') as f:
        conf: dict = yaml.safe_load(f)
    
    model_id = conf['model']['id']
    cache_path = os.environ['HF_HOME'] + '/hub'

    hf_token = HF_TOKEN if conf['model']['requires_auth'] else None
    revision = conf['model']['revision'] if 'revision' in conf['model'] else "main"

    if need_image_emb and not conf['model']['can_embed_images']:
        raise Exception('The chosen model cannot embed images as required by need_image_emb')

    if need_text_emb and not conf['model']['can_embed_text']:
        raise Exception('The chosen model cannot embed text as required by need_text_emb')

    trust_remote_code = False
    if 'trust_remote_code' in conf['model'] and conf['model']['trust_remote_code'] == True:
        trust_remote_code = True

    return SentenceTransformer(
        model_name_or_path=model_id,
        cache_folder=cache_path,
        token=hf_token,
        revision=revision,
        trust_remote_code=trust_remote_code
    )
