import torch
from pathlib import Path
from src.processing.captioning import ImageCaptioner

class TestCommands:
    """
    Commands used to run tests.
    """

    def gpu(self) -> None:
        """
        Checks if GPUs are available and working correctly.
        """
        cuda_av = torch.cuda.is_available()

        print(f'CUDA Available: {cuda_av}')

        if cuda_av:
            for i in range(torch.cuda.device_count()):
                print(f'Found GPU device: {torch.cuda.get_device_name(i)}')

                a = torch.rand(10, 10).to(f'cuda:{i}')
                b = torch.rand(10, 20).to(f'cuda:{i}')
                r = a @ b
            
            print('GPU Test successful')

    def gen_single_caption(self,
                           model_config_path: str,
                           image_path: str,
                           prompt: str,
                           max_new_tokens: int = 200
                           ) -> None:

        cap = ImageCaptioner(model_config_path)

        if Path(prompt).is_file():
            prompt = Path(prompt).read_text().strip()

        caption = cap.caption([image_path], prompt, max_new_tokens, 1)

        print('\n\n')
        print(caption[0])
        print('\n\n')
