from typing import Any, Callable, Optional
from omegaconf import DictConfig
from torch.utils.data.dataset import Dataset
from torch.utils.data.dataloader import default_collate

__all__ = ["PadoDataset"]


class PadoDataset(Dataset):
    """
    Base class of datasets.
    """

    def __len__(self) -> int:
        raise NotImplementedError

    def __getitem__(self, index: int) -> Any:
        raise NotImplementedError

    @staticmethod
    def collate_fn(batch):
        """
        How to aggregate the data from batch.
        :param:     batch:  List of data samples
        :return:            Collated batch of any type.
        """
        return default_collate(batch)

    @classmethod
    def from_config(cls,
                    cfg: DictConfig,
                    transform: Optional[Callable] = None,
                    target_transform: Optional[Callable] = None):
        raise NotImplementedError
