from typing import Any
from omegaconf import DictConfig
from pado.core import PadoModule

__all__ = ["PadoMetric"]


class PadoMetric(PadoModule):
    """
    Base class of metrics.
    """

    def __init__(self):
        super().__init__()

    def __call__(self, *args, **kwargs) -> Any:
        return self.forward(*args, **kwargs)

    def forward(self, *args, **kwargs) -> Any:
        raise NotImplementedError

    @classmethod
    def from_config(cls, cfg: DictConfig):
        raise NotImplementedError
