from typing import Any
from omegaconf import DictConfig
from pado.core.module import PadoModule

__all__ = ["PadoTransform"]


class PadoTransform(PadoModule):

    def __init__(self):
        super().__init__()

    def __call__(self, x: Any) -> Any:
        return self.forward(x)

    def forward(self, x: Any) -> Any:
        # only accept 1-to-1 transform.
        raise NotImplementedError

    @classmethod
    def from_config(cls, cfg: DictConfig):
        raise NotImplementedError
