from typing import Any, Callable, Iterable
from omegaconf import DictConfig
from pado.core.base.transform import PadoTransform

__all__ = ["Compose"]


class Compose(PadoTransform):
    """
    Composition of multiple callable transforms.
    This special transform is not registered.
    """

    def __init__(self, transforms: Iterable[Callable]) -> None:
        super().__init__()
        self.transforms = list(transforms)

    def __len__(self):
        return len(self.transforms)

    def forward(self, x: Any) -> Any:
        # sequentially pass each transform
        for transform in self.transforms:
            x = transform(x)
        return x

    def __getitem__(self, idx: int):
        if idx < 0:
            idx = len(self.transforms) + idx
        if not (0 <= idx < len(self)):
            raise IndexError(f"Composed transforms index overflow: {len(self)} transforms, but accessed with {idx}.")
        return self.transforms[idx]

    @classmethod
    def from_config(cls, cfg: DictConfig):
        raise NotImplementedError
