import torch
from dynamic_graph import *
import math
import numpy as np

class DirectedEquiTopo(DynamicGraph):
    def __init__(self, n_nodes, m=5, seed=None):
        w_list = []
        
        self.state = np.random.RandomState(seed)
        self.bias_index = self.state.choice(list(range(1, n_nodes)), m).tolist()
            
        w = torch.zeros((n_nodes, n_nodes))
    
        for u in self.bias_index:
            for i in range(n_nodes):
                for j in range(n_nodes):
                    if i == ((j + u) % n_nodes):
                        w[i, j] += (n_nodes-1) / n_nodes
                    elif i == j:
                        w[i, j] += 1 / n_nodes
        w /= m        
        super().__init__([w])
        
