
from deephyper.problem import NaProblem

from experiments.imagenet.load_data import load_data
from experiments.imagenet.search_space import create_search_space

Problem = NaProblem()

Problem.load_data(load_data)

Problem.search_space(create_search_space)

Problem.hyperparameters(
    num_epochs=200,
    batch_size=512, learning_rate=0.1, optimizer='sgd', momentum=0.9,
    weight_decay=0.0005, nesterov=True,
)

Problem.loss('categorical_crossentropy')


Problem.metrics(['acc', 'top_k_categorical_accuracy'])

Problem.objective('val_acc__last')

if __name__ == '__main__':
    print(Problem)
