
from deephyper.problem import NaProblem

from experiments.lines.load_data import load_data
from experiments.lines.search_space import create_search_space

Problem = NaProblem()

Problem.load_data(load_data, size=128)

Problem.search_space(create_search_space)

Problem.hyperparameters(
    batch_size=512, learning_rate=0.01, optimizer='adam', num_epochs=1
)

Problem.loss('categorical_crossentropy')

Problem.metrics(['acc'])

Problem.objective('val_acc__last')

if __name__ == '__main__':
    print(Problem)
