
import numpy as np


def is_pareto_efficient(
        costs: np.ndarray,
        return_mask: bool = True,
        maximize: bool = True,
) -> np.ndarray:
    
    assert costs.ndim == 2
    costs_ = np.copy(costs)
    costs_[np.isnan(costs_)] = np.inf
    if maximize:
        costs_ = -costs_
    is_efficient, n_points = np.arange(costs_.shape[0]), costs_.shape[0]
    next_point_index = 0  
    while next_point_index < len(costs_):
        nondominated_point_mask = np.any(costs_ < costs_[next_point_index],
                                         axis=1)
        nondominated_point_mask[next_point_index] = True
        
        is_efficient = is_efficient[nondominated_point_mask]
        costs_ = costs_[nondominated_point_mask]
        next_point_index = np.sum(
            nondominated_point_mask[:next_point_index]) + 1
    if return_mask:
        is_efficient_mask = np.zeros(n_points, dtype=bool)
        is_efficient_mask[is_efficient] = True
        return is_efficient_mask
    return is_efficient  


def nondominating(
        costs: np.ndarray,
        maximize: bool = True,
) -> np.ndarray:
    mask = is_pareto_efficient(costs, maximize=maximize, return_mask=True)
    return costs[mask]
