
from deephyper.problem import NaProblem

from experiments.cifar10.load_data import load_data
from experiments.cifar10.search_space import create_search_space

Problem = NaProblem()

Problem.load_data(load_data)

Problem.search_space(create_search_space)

Problem.hyperparameters(
    batch_size=512, learning_rate=0.1, optimizer='sgd', momentum=0.9,
    weight_decay=0.0005,
    nesterov=True, num_epochs=12,
)

Problem.loss('categorical_crossentropy')

Problem.metrics(['acc'])

Problem.objective('val_acc__max')

if __name__ == '__main__':
    print(Problem)
