
import logging

from functools import wraps
from functools import partial


def get_logger(name=None):
    logger_ = logging.getLogger(name)
    return logger_


def configure_logging(level=logging.INFO):
    logging.basicConfig(
        level=level,
        format='%(asctime)s %(levelname)-8s %(message)s',
        datefmt='%Y-%m-%d %H:%M:%S',
    )


def log_exceptions(func=None, logger=None):
    if func is None:
        return partial(log_exceptions, logger=logger)

    if logger is None:
        logger = get_logger(__name__)

    @wraps(func)
    def wrapper(*args, **kwargs):
        try:
            ret = func(*args, **kwargs)
            return ret
        except Exception:  
            logger.exception(f'Exception occurred while running '
                             f'{func.__name__}. Raising...')
            raise

    return wrapper
