#!/bin/sh

# 自己隨便設定一個session名稱
SESSION_NAME="0503_walker_cn-der"

# 檢查這個session本來是否存在
tmux has-session -t ${SESSION_NAME} 2>/dev/null

if [ $? != 0 ]; then
    # 先開啟新的session
    # shell 0
    tmux new-session -s ${SESSION_NAME} -n bash -d
    tmux send-keys -t ${SESSION_NAME}:0 'conda activate Dyn' C-m
    tmux send-keys -t ${SESSION_NAME}:0 'python main.py --seed 1' C-m

    # 已經有session了所以使用new-window
    # shell 1
    tmux new-window -n bash -t ${SESSION_NAME}
    tmux send-keys -t ${SESSION_NAME}:1 'conda activate Dyn' C-m
    tmux send-keys -t ${SESSION_NAME}:1 'python main.py --seed 2' C-m

    # shell 2
    tmux new-window -n bash -t ${SESSION_NAME}
    tmux send-keys -t ${SESSION_NAME}:2 'conda activate Dyn' C-m
    tmux send-keys -t ${SESSION_NAME}:2 'python main.py --seed 3' C-m

    # shell 3
    tmux new-window -n bash -t ${SESSION_NAME}
    tmux send-keys -t ${SESSION_NAME}:3 'conda activate Dyn' C-m
    tmux send-keys -t ${SESSION_NAME}:3 'python main.py --seed 4' C-m

    # shell 4
    tmux new-window -n bash -t ${SESSION_NAME}
    tmux send-keys -t ${SESSION_NAME}:4 'conda activate Dyn' C-m
    tmux send-keys -t ${SESSION_NAME}:4 'python main.py --seed 5' C-m
    '
    # shell 5
    tmux new-window -n bash -t ${SESSION_NAME}
    tmux send-keys -t ${SESSION_NAME}:5 'conda activate Dyn' C-m
    tmux send-keys -t ${SESSION_NAME}:5 'python main.py --seed 6' C-m

    # shell 6
    tmux new-window -n bash -t ${SESSION_NAME}
    tmux send-keys -t ${SESSION_NAME}:6 'conda activate Dyn' C-m
    tmux send-keys -t ${SESSION_NAME}:6 'python main.py --seed 7' C-m

    # shell 7
    tmux new-window -n bash -t ${SESSION_NAME}
    tmux send-keys -t ${SESSION_NAME}:7 'conda activate Dyn' C-m
    tmux send-keys -t ${SESSION_NAME}:7 'python main.py --seed 8' C-m

    # shell 8
    tmux new-window -n bash -t ${SESSION_NAME}
    tmux send-keys -t ${SESSION_NAME}:8 'conda activate Dyn' C-m
    tmux send-keys -t ${SESSION_NAME}:8 'python main.py --seed 9' C-m
    '

    # 將畫面切回一開始的window
    tmux select-window -t ${SESSION_NAME}:0
fi

tmux attach-session -t ${SESSION_NAME}
