import os
os.environ["CUDA_VISIBLE_DEVICES"]="1"

import numpy as np
import torch
import gym
import argparse
import os

import utils
import TD3
import OurDDPG
import DDPG

import half_cheetah_v3
import hopper_v3
import ant_v3
import walker2d_v3
import dst_d


PREF = [[0.9, 0.1], [0.8, 0.2], [0.7, 0.3], [0.6, 0.4], [0.5, 0.5], [0.4, 0.6], [0.3, 0.7], [0.2, 0.8],[0.1,0.9]]



# Runs policy for X episodes and returns average reward
# A fixed seed is used for the eval environment
def eval_policy(policy, env_name, seed, eval_episodes, preference):
	eval_env = gym.make(env_name)
	eval_env.seed(seed + 100)
	returns = np.empty((eval_episodes, eval_env.reward_space))


	preference = np.array(preference)
	for i in range(eval_episodes):
		state, done = eval_env.reset(), False
		episode_reward = np.zeros(eval_env.reward_space)
		
		
		while not done:
			action = policy.select_action(np.array(state), preference)
			state, reward, done, _ = eval_env.step(action)
			episode_reward += reward
		returns[i] = episode_reward

	mean_return = np.mean(returns, axis=0)
	

	print("---------------------------------------")
	print(f"Evaluation over {eval_episodes} episodes: ",mean_return,f'preference', preference)
	print("---------------------------------------")
	return mean_return

def get_pref(reward_dim):
	preference = np.random.rand( reward_dim)
	preference = preference.astype(np.float32)
	preference /= preference.sum()
	'''
	PRE = [[0.9, 0.1], [0.5,0.5], [0.1,0.9]]
	preference = np.array(random.choice(PRE))
	preference = preference.astype(np.float32)
	'''
	return preference

if __name__ == "__main__":
	
	parser = argparse.ArgumentParser()
	parser.add_argument("--policy", default="OurDDPG")                  # Policy name (TD3, DDPG or OurDDPG)
	#parser.add_argument("--env", default="HalfCheetah-v2")          # OpenAI gym environment name
	#parser.add_argument("--env", default="MO_hopper-v0")          # OpenAI gym environment name
	#parser.add_argument("--env", default="MO_ant-v0")          # OpenAI gym environment name
	#parser.add_argument("--env", default="MO_walker-v0")          # OpenAI gym environment name
	#parser.add_argument("--env", default="MO_half_cheetah-v0")          # OpenAI gym environment name
	parser.add_argument("--env", default="dst_d-v0")          # OpenAI gym environment name
	parser.add_argument("--seed", default=0, type=int)              # Sets Gym, PyTorch and Numpy seeds
	parser.add_argument("--start_timesteps", default=25e3, type=int)# Time steps initial random policy is used
	parser.add_argument("--eval_freq", default=1e4, type=int)       # How often (time steps) we evaluate
	parser.add_argument("--max_timesteps", default=3e6, type=int)   # Max time steps to run environment
	parser.add_argument("--expl_noise", default=0.1)                # Std of Gaussian exploration noise
	parser.add_argument("--batch_size", default=256, type=int)      # Batch size for both actor and critic
	parser.add_argument("--discount", default=0.99)                 # Discount factor
	parser.add_argument("--tau", default=0.005)                     # Target network update rate
	parser.add_argument("--policy_noise", default=0.2)              # Noise added to target policy during critic update
	parser.add_argument("--noise_clip", default=0.5)                # Range to clip target policy noise
	parser.add_argument("--policy_freq", default=2, type=int)       # Frequency of delayed policy updates
	parser.add_argument("--save_model", action="store_true")        # Save model and optimizer parameters
	parser.add_argument("--load_model", default="")                 # Model load file name, "" doesn't load, "default" uses file_name
	args = parser.parse_args()

	file_name = f"{args.policy}_{args.env}_{args.seed}"
	print("---------------------------------------")
	print(f"Policy: {args.policy}, Env: {args.env}, Seed: {args.seed}")
	print("---------------------------------------")

	if not os.path.exists("./results"):
		os.makedirs("./results")
	summary_dir = os.path.join("./results", file_name)
	if not os.path.exists(summary_dir):
		os.makedirs(summary_dir)
	if not os.path.exists("./results"):
		os.makedirs("./results")

	if not os.path.exists("./models"):
		os.makedirs("./models")
	model_dir = os.path.join("./models",file_name)
	if not os.path.exists(model_dir):
		os.makedirs(model_dir)


	env = gym.make(args.env)

	# Set seeds
	env.seed(args.seed)
	env.action_space.seed(args.seed)
	torch.manual_seed(args.seed)
	np.random.seed(args.seed)
	
	state_dim = env.observation_space.shape[0]
	action_dim = env.action_space.shape[0] 
	reward_dim = env.reward_space
	max_action = float(env.action_space.high[0])

	kwargs = {
		"state_dim": state_dim,
		"action_dim": action_dim,
		"reward_dim": reward_dim,
		"max_action": max_action,
		"discount": args.discount,
		"tau": args.tau,
	}

	# Initialize policy
	if args.policy == "TD3":
		# Target policy smoothing is scaled wrt the action scale
		kwargs["policy_noise"] = args.policy_noise * max_action
		kwargs["noise_clip"] = args.noise_clip * max_action
		kwargs["policy_freq"] = args.policy_freq
		policy = TD3.TD3(**kwargs)
	elif args.policy == "OurDDPG":
		policy = OurDDPG.DDPG(**kwargs)
	elif args.policy == "DDPG":
		policy = DDPG.DDPG(**kwargs)

	if args.load_model != "":
		policy_file = file_name if args.load_model == "default" else args.load_model
		policy.load(f"./models/{policy_file}")

	replay_buffer = utils.ReplayBuffer(state_dim, action_dim, reward_dim)
	
	# Evaluate untrained policy
	#evaluations = [eval_policy(policy, args.env, args.seed)]
	monitor = []
	for i in PREF:
		moni = utils.Monitor(spec = {'pref':i,'seed':args.seed,}, path=summary_dir )
		monitor.append(moni)
	state, done = env.reset(), False
	p = get_pref(reward_dim)
	episode_reward = np.zeros(reward_dim)
	episode_timesteps = 0
	episode_num = 0

	for t in range(int(args.max_timesteps)):
		
		episode_timesteps += 1

		# Select action randomly or according to policy
		if t < args.start_timesteps:
			action = env.action_space.sample()
		else:
			action = (
				policy.select_action(np.array(state), p)
				+ np.random.normal(0, max_action * args.expl_noise, size=action_dim)
			).clip(-max_action, max_action)

		# Perform action
		next_state, reward, done, _ = env.step(action) 
		done_bool = float(done) if episode_timesteps < env._max_episode_steps else 0

		# Store data in replay buffer
		replay_buffer.add(state, action, next_state, reward, done_bool)

		state = next_state
		episode_reward += reward

		# Train agent after collecting sufficient data
		if t >= args.start_timesteps:
			policy.train(replay_buffer, args.batch_size)

		if done: 
			# +1 to account for 0 indexing. +0 on ep_timesteps since it will increment +1 even if done=True
			print(f"Total T: {t+1} Episode Num: {episode_num+1} Episode T: {episode_timesteps} Reward: {episode_reward}")
			# Reset environment
			state, done = env.reset(), False
			p = get_pref(reward_dim)
			episode_reward = np.zeros(reward_dim)
			episode_timesteps = 0
			episode_num += 1 

		# Evaluate episode
		if (t + 1) % args.eval_freq == 0:
			for i in range(len(PREF)):
				mean_return = eval_policy(policy, args.env, args.seed, 20,PREF[i])
				monitor[i].update( (t+1) / args.eval_freq, np.dot(PREF[i], mean_return), *mean_return)
		            
		        #np.save(f"./results/{file_name}", evaluations)
		if (t+1) % 100000 == 0:
			policy.save(f"./models/{file_name}/", int((t+1)/100000) )
                    
