# Efficiently Quantifying Individual Agent Importance in Cooperative MARL

Please see here the code accompanying the paper titled `Efficiently Quantifying Individual Agent Importance in Cooperative MARL` which may be used for running experiments, computing the additionally proposed metrics and for aggregating all raw experiment results.

# Running experiments 
In order to run experiments we suggest making use of Docker by running: 
```
docker build -t epymarl:latest -f docker/Dockerfile . 
docker run --rm -it -p 6006:6006/tcp epymarl:latest
``` 

Alternatively, `conda` may be used as follows: 
```
conda create -n epymarl python=3.9 -y
conda activate epymarl 
pip install -r requirements.txt
```

All experiment configuration files may be found in `src/config/algs`. We have made task specific configuration files for each algorithm used in our work by adding either `_lbf` or `_rware` as a suffix to the algorithm name. A simple of example of running `IQL` on the `Foraging-15x15-4p-3f-v2` LBF task would then be: 

```sh
python3 src/main.py --config=iql_lbf --env-config=gymma with env_args.time_limit=25 env_args.key="lbforaging:Foraging-15x15-4p-3f-v2"
```

Additional metrics, like the agent importance, may also be turned on or off. This can either be done manually on lines 60-64 in `src/config/default.yaml` or via the commandline as follows: 

```sh
python3 src/main.py --config=iql_lbf --env-config=gymma with env_args.time_limit=25 env_args.key="lbforaging:Foraging-15x15-4p-3f-v2" compute_agent_importance=True
```

In order to rerun all experiments from the paper, please run the following script. It is important to note that this script will run all experiment configurations sequentially. Here `experiment_tag` is a unique experiment identifier which may be passed in for experiment logging. Additionally Neptune logging my be configured by adding a Neptune API token on your local machine and by setting `use_neptune` to `True` in `src/config/default.yaml`. 
```sh
run_sweep.sh experiment_tag
```

# Included additional metrics
We include code for computing both the Agent Importance and Shapley value in this repo. Relevant code for each metric may be viewed in the `src/metrics` directory. 

# Aggregating experimental results 
In order to aggregate all experiment data please create a new virtual environment and install the following dependencies found in the `requirements_aggregate_plot.txt` files. 

All experiment data may be downloaded from the following [link](https://sites.google.com/view/agent-importance/home). Please note that this data has already been processed using the python script `process_data/data_process_pipeline.py`. In all cases downloaded folders will have the following structure: 

```
└── experiment_name/
    ├── algorithm_name/
    │   └── environment_name:task_name/
    │       └── independent_run_number/
    │           ├── metric_name/
    │           │   └── master_<metric_name>.json
    │           └── metrics.json
    └── <experiment_name>.json
```

Here the `<experiment_name>.json` file has a structure matching the requirements given in the [following repo](https://github.com/instadeepai/marl-eval#data-structure-for-raw-experiment-data-) and may be used to produce the sample efficiency curves, the probability of improvement plots, the performance profile curves and the aggregated environment level scores using the `plot_data/environment_aggregation_plots.py` script. Additionally the `master_<metric_name>.json` files will have the following structure: 

``` 
{
  <step_count> : {
    <recorded_metric_name>: [data]
  }
}
```
Where `step_count` indicates the current environment step when a given set of metrics was recorded and the corresponding list will contain all the datapoints that were logged at that particular step. 

We also provide a minimal set of experimental data, accessible at `plot_data/minimal_experiment_data/` that may be used with the jupyter notebooks given in `plot/data/` to produce the correlation heatmaps, ranking plots, scalability plots and agent importance plots found in the paper. 