Note: Except for the README.md, the code is in its original form as generated by AI and has not been refined by humans.

# How to run 
## Environment
Install related packages
```bash
pip install -r requirement.txt
```

## Dataset
Download datasets under `/datasets/LoCoOp` folder.


#### In-distribution Datasets
We use ImageNet-1K as the ID dataset.
- Create a folder named `imagenet/` under `/datasets/LoCoOp` folder.
- Create `images/` under `imagenet/`.
- Download the dataset from the [official website](https://image-net.org/index.php) and extract the training and validation sets to `/datasets/LoCoOp/imagenet/images`.
  

#### Out-of-distribution Datasets
We use the large-scale OOD datasets [iNaturalist](https://arxiv.org/abs/1707.06642), [SUN](https://vision.princeton.edu/projects/2010/SUN/), [Places](https://arxiv.org/abs/1610.02055), and [Texture](https://arxiv.org/abs/1311.3618) curated by [Huang et al. 2021](https://arxiv.org/abs/2105.01879). We follow instructions from this [repository](https://github.com/deeplearning-wisc/large_scale_ood#out-of-distribution-dataset) to download the subsampled datasets.


The overall file structure is as follows:
```

|-- /datasets/LoCoOp
    |-- imagenet
        |-- imagenet-classes.txt
        |-- images/
            |--train/ # contains 1,000 folders like n01440764, n01443537, etc.
            |-- val/ # contains 1,000 folders like n01440764, n01443537, etc.
    |-- iNaturalist
    |-- SUN
    |-- Places
    |-- Texture
    ...
```

## Quick Start
For the main experiments, you can run:
```bash
CUDA_VISIBLE_DEVICES=0 python improved_proposed_method.py --output-dir results/ 
```

For plotting, you can run:
```bash
python plot.py --input-file results_example/scores.npz --output-dir results_examples/baseline_plot
```


## Results File
The result file is `result/improved_proposed_method/results.json`.