# Implementation Plan: Entropy-Weighted Local Concept Matching (ELCM)

## Overview
Implement Entropy-Weighted Local Concept Matching to improve GL-MCM by suppressing spurious local patch alignments through entropy-based weighting.

## Current GL-MCM Implementation Analysis
- Local features: `local_features` with shape `[batch, spatial_patches, feature_dim]`  
- Local similarities: `output_local = local_features @ text_features.T` → `[batch, spatial_patches, num_classes]`
- Local softmax: `smax_local = softmax(output_local/T, dim=-1)` → per-patch class probabilities
- Current local score: `local_score = -max(smax_local, axis=(1,2))` (max-pooling across patches and classes)

## Proposed ELCM Method

### 1. Entropy Computation
For each spatial patch i, compute:
- Class probability distribution: `p_{i,c} = softmax(sim(x'_i, y_c)/τ)` (already computed as `smax_local`)
- Shannon entropy: `H_i = -Σ_c p_{i,c} * log(p_{i,c})`
- Entropy weight: `w_i = exp(-α * H_i)` where α ∈ {0.5, 1, 2}

### 2. Weighted Local Score
- Per-patch max confidence: `max_c p_{i,c}` (max over classes for each patch)
- Entropy-weighted local score: `S_ELCM = Σ_i w_i * max_c p_{i,c}`

### 3. Integration with Global Score
- Final score: `S = S_MCM + λ * S_ELCM`
- Use same λ value as baseline GL-MCM (0.5)

## Implementation Steps

1. **Create `proposed_method.py`**: Entry script with same interface as baseline.py
2. **Modify scoring function**: Add entropy weighting to local score computation
3. **Add alpha parameter**: Test with α ∈ {0.5, 1, 2}, default α=1
4. **Maintain compatibility**: Keep same input/output formats (scores.npz, results.json)

## Key Changes Required
- Modify `get_ood_scores()` function to implement ELCM weighting
- Add entropy computation for local patches
- Replace max-pooling with entropy-weighted sum
- Add alpha parameter for entropy weighting strength

## Expected Improvements
- Reduced FPR95 by suppressing noisy background patches
- Better performance on multi-object images
- Minimal computational overhead (only entropy calculation)