#!/usr/bin/env python3
"""Test script to verify function signatures were updated correctly."""

import inspect
from improved_proposed_method import (
    compute_topk_class_conditional_weights,
    get_ood_scores
)

print("Checking function signatures...")

# Check compute_topk_class_conditional_weights
sig1 = inspect.signature(compute_topk_class_conditional_weights)
params1 = list(sig1.parameters.keys())
print(f"\ncompute_topk_class_conditional_weights parameters: {params1}")

# Check for required spatial correlation parameters
required_params = ['gamma', 'use_spatial_correlation', 'patch_grid_size', 'correlation_threshold', 'spatial_decay']
missing_params1 = [p for p in required_params if p not in params1]
if missing_params1:
    print(f"  WARNING: Missing parameters: {missing_params1}")
else:
    print("  ✓ All spatial correlation parameters present")

# Check get_ood_scores
sig2 = inspect.signature(get_ood_scores)
params2 = list(sig2.parameters.keys())
print(f"\nget_ood_scores parameters: {params2}")

# Check for gamma parameter
if 'gamma' not in params2:
    print("  WARNING: Missing gamma parameter")
else:
    print("  ✓ Gamma parameter present")

print("\nAll signature updates completed successfully!")