# Reducing Excessive Margin to Achieve a Better Accuracy vs. Robustness Trade-off

This repository contains the code for the paper "Reducing Excessive Margin to Achieve a Better Accuracy vs. Robustness Trade-off". 

## Requirements

Our code has been implemented and tested with `Python 3.8.5` and `PyTorch 1.8.0`. To install the required packages:
```bash
$ pip install -r requirements.txt
```

## Repository Structure
```
.
└── core                 # Source code for the experiments
    ├── attacks              # Adversarial attacks
    ├── data                 # Data setup and loading
    ├── models               # Model architectures
    └── utils                # Helpers, training and testing functions
    └── metrics.py           # Evaluation metrics
└── gowal21uncovering	 # Approach from Gowal et al., 2020
    └── utils                # Helpers, training and testing functions
└── train.py		 # Training script
└── train-wa.py		 # Training with model weight averaging
└── eval-aa.py		 # AutoAttack evaluation script
└── eval-adv.py		 # PGD+ and CW evaluation script
└── eval-rb.py		 # RobustBench evaluation script
```

## Training

Use [`train.py`](./train.py) for standard, adversarial, TRADES, MART and HAT training. Example commands for HAT training are provided below:

Fisrt, run standard training on CIFAR-10:
```
$ python train.py --data-dir <data_dir> \
    --log-dir <log_dir> \
    --data cifar10 \
    --desc std-cifar10 \
    --model resnet18 \
    --num-std-epochs 50
```

Then, run the following command to perform helper-based adversarial training (HAT):

```
$ python train.py --data-dir <data_dir> \
    --log-dir <log_dir> \
    --data cifar10 \
    --desc hat-cifar10 \
    --model resnet18 \
    --num-adv-epochs 50 \
    --helper-model std-cifar10 \
    --beta 2.5 \
    --gamma 0.5
```

For HAT with the experimental setup from "[Uncovering the Limits of Adversarial Training against Norm-Bounded Adversarial Examples](https://arxiv.org/abs/2010.03593)" (Gowal et al., 2020) or "[Fixing Data Augmentation to Improve Adversarial Robustness](https://arxiv.org/abs/2103.01946)" (Rebuffi et al., 2021), use the following command:

```
$ python train-wa.py --data-dir <data_dir> \
    --log-dir <log_dir> \
    --desc hat-cifar10s \
    --data cifar10s \
    --batch-size 1024 \
    --batch-size-validation 512 \
    --model wrn-28-10-swish \
    --num-adv-epochs 400 \
    --lr 0.4 --tau 0.995 \
    --label-smoothing 0.1 \
    --unsup-fraction 0.7 \
    --aux-data-filename <path_to_additional_data> \
    --helper-model std-cifar10 \
    --beta 3.5 \
    --gamma 0.5
```

## Evaluation

For evaluation with AutoAttack, run:
```
$ python eval-aa.py --data-dir <data_dir> \
    --log-dir <log_dir> \
    --desc hat-cifar10
```

To perform an extensive evaluation of the trained model with PGD+ and CW attacks:
```
$ python eval-adv.py --wb --data-dir <data_dir> \
    --log-dir <log_dir> \
    --desc hat-cifar10
```
