# Tackling the Limitation of Neural ODEs through Partial Differential Equations (CTFNO)
![Python 3.9](https://img.shields.io/badge/python-3.9-red.svg)
![PyTorch 1.11.0](https://img.shields.io/badge/pytorch-1.11.0-blue.svg)

## Setup
0. Check CUDA version (we used CUDA 11.3)
1. Create conda environment: `conda create -n ctfno python=3.9`
2. Activate: `conda activate ctfno`
3. Install dependencies: `conda env update -f requirements.yml --prune`

## Download dataset
- The datasets for Reaction ODE, Heat, Burgers' equation, and Plane Vibration can be downloaded at [this LINK][dataset].
    - The datasets for Reaction ODE, Heat, and Burgers' equation were synthesized numerically.
- The datasets for Mujoco Hopper, PhysioNet and Person Activity are downloaded and processed when `main.py` is run for the first time.
    - Raw datasets : [MuJoCo][hopper], [PhysioNet][physionet], [Activity][activity] (Refer to [Yulia et al. 2019][latentode])
- Each dataset should be placed in `data/[data_name]/`.

## Run
- Heat equation
```
python main.py --data heat --exp-name test
```
- Burgers' equation
```
python main.py --data burgers --exp-name test
```
- Reaction ODE equation
```
python main.py --data ode --exp-name test
```
- Plane Vibration 
```
python main.py --data pv --exp-name test
```
- MuJoCo (Hopper)
```
python main.py --data hopper --exp-name test
```
- PhysioNet
```
python main.py --data physionet --exp-name test
```
- Activity
```
python main.py --data activity --exp-name test
```

## License
All materials are provided under the MIT license.<br>
The (synthesized) datasets for heat equation, Burgers' equation and reaction ODE equation are provided under the MIT license.


[dataset]: https://drive.google.com/drive/u/1/folders/11G91B3QFT3v16pkAacFDQVCHR0DuJRD1 
[hopper]: https://www.cs.toronto.edu/~rtqichen/datasets/HopperPhysics/training.pt
[physionet]: https://physionet.org/physiobank/database/challenge/2012/
[activity]: https://archive.ics.uci.edu/ml/machine-learning-databases/00196/ConfLongDemo_JSI.txt
[latentode]: https://github.com/YuliaRubanova/latent_ode
[stribor]: https://github.com/mbilos/stribor
