#!/bin/bash

devices=0

CUDA_VISIBLE_DEVICES=$devices python -u ./train_continual_baseline.py \
--task_path ./data/wikisql_task_stream_distribution_2/task_{}/{} \
--plm_model ../../../resources/grappa \
--frozen_mode tuning_plm \
--baseline_name gem \
--memory_size 10 \
--emar_second_iter 1 \
--max_seq_length 300 \
--encoder_dim 1024 \
--max_patience 20 \
--seed 257 \
--cuda \
--lr 2e-4 \
--epoch_eval 40 \
--epoch 50 \
--task_num 10 \
--beam_size 5 \
--batch_size 16 \
--accumulation_step 2 \
--combine_K 3 \
--column_pointer \
--few_shot -1 \
--device $devices


# seed
# 117 -0.0415 [4, 0, 7, 5, 6, 9, 1, 8, 2, 3]
# 17 -0.0264
# 113 -0.0263
# 137 -0.0545 [7, 0, 4, 3, 5, 9, 8, 6, 2, 1]
# 197 -0.0281
# 257 -0.0335 [3, 8, 0, 7, 9, 4, 2, 1, 6, 5]
# 277 -0.0312 [4, 6, 8, 7, 9, 0, 5, 3, 2, 1]
# 397 -0.0388 [8, 4, 7, 2, 0, 5, 3, 6, 9, 1]