#!/bin/bash

# Quick HALPE Environment Setup with uv
# Usage: ./quick_setup.sh

set -e

echo "🚀 Quick HALPE Environment Setup with uv"

# Install uv if not present
if ! command -v uv &> /dev/null; then
    echo "📦 Installing uv..."
    curl -LsSf https://astral.sh/uv/install.sh | sh
    export PATH="$HOME/.local/bin:$PATH"
fi

# Create and setup environment
echo "🔧 Creating environment with Python 3.10.0..."
uv venv ../halpe_uv --python 3.10.0
uv pip install --python ../halpe_uv/bin/python -r requirements_halpe.txt

echo "✅ Environment ready! Activate with: source ../halpe_uv/bin/activate" 