from dataclasses import dataclass, field

@dataclass
class BaseArguments:
    seed: int = field(default=42, metadata={'help': 'Random number generator seed to set.'})
    num_workers: int = field(default=0,
                             metadata={'help': 'Number of PyTorch data loader subprocesses. 0 means'
                                               ' that the data will be loaded in the main process.'})
    output_dir: str = field(default='out',
                            metadata={'help': 'The output directory where the model '
                                              'predictions and checkpoints will be written. '
                                              'The model and the tokenizer will be saved in '
                                              'the `out` sub-folder.'})
    overwrite_output: bool = field(default=False,
                                   metadata={'help': 'Overwrite the content of the output directory and '
                                                     'log file. Use this to continue training if output '
                                                     'directory contains model checkpoint.'})
    device: str = field(default="cuda", metadata={'help': 'Device to run computations on: "cuda" or "cpu".'})
    cache_dir: str = field(default=None, metadata={'help': 'Global cache directory for all HuggingFace downloads (models, datasets, etc.). Set to null to use HF defaults.'})
