classdef FCSEA < ALGORITHM
    methods
        function main(Algorithm,Problem)
            %% Parameter setting
            [k,gmax] = Algorithm.ParameterSet(6,3000);

            %% Initalize the population by Latin hypercube sampling
            N          = min(11*Problem.D-1,109);
            PopDec     = UniformPoint(N,Problem.D,'Latin');
            Population = Problem.Evaluation(repmat(Problem.upper-Problem.lower,N,1).*PopDec+repmat(Problem.lower,N,1));
            Arc        = Population;
            
            %% Initialize the network
            learning_rate = 0.05;
            momentum = 0.9;
            n_inputs = Problem.D;
            n_outputs_decoder = Problem.D;
            n_outputs_classifier = 1;
            n_hidden_layers_shared = 1;
            n_hidden_units_shared = min(ceil(Problem.D/2),5);
            n_hidden_layers_decoder = 0;
            n_hidden_units_decoder = 10;
            n_hidden_layers_classifier = 1;
            n_hidden_units_classifier = 2*n_hidden_units_shared;
            %maxEpochs = 400;
            epoch = 500;
            Lower = Problem.lower;
            Upper = Problem.upper;

            %% Optimization
            while Algorithm.NotTerminated(Arc)
                % Select reference solutions and preprocess the data
                Ref    = EnvironmentalSelection_Clustering(Population,Problem.N,k);
                Input  = Population.decs;  
                Output = GetOutput(Population.objs,Ref.objs); 
                rr     = sum(Output)/length(Output);
                tr     = min(rr,1-rr)*0.5;
                [TrainIn,TrainOut,TestIn,TestOut] = DataProcess(Input,Output);

                TrainIn = (TrainIn-repmat(Lower,size(TrainIn,1),1))./repmat(Upper-Lower,size(TrainIn,1),1);
                TestIn = (TestIn-repmat(Lower,size(TestIn,1),1))./repmat(Upper-Lower,size(TestIn,1),1);

                net = AFNN_CSIV(n_inputs, n_outputs_decoder, n_outputs_classifier, ...
                        n_hidden_layers_shared, n_hidden_layers_decoder, n_hidden_layers_classifier,...
                        n_hidden_units_shared, n_hidden_units_decoder, n_hidden_units_classifier, ...
                        learning_rate, momentum);

                net.train_shared_decoder_v2(TrainIn, TrainIn, 0.01, epoch);

                net.train_classifier_v2(TrainIn, TrainOut, 0.01, epoch);

                % Error rates calculation
                TestPre = net.predictClassifier(TestIn);
                IndexGood = TestOut==1;
                p0 = sum(abs((TestOut(IndexGood)-TestPre(IndexGood))))/sum(IndexGood);
                p1 = sum(abs((TestOut(~IndexGood)-TestPre(~IndexGood))))/sum(~IndexGood);

                % Surrogate-assisted selection and update the population
                if rand < 0.95
                    Input_norm = (Input-repmat(Lower,size(Input,1),1))./repmat(Upper-Lower,size(Input,1),1);
				    Input_encoder = net.forwardEncoder(Input_norm);
                    Input_encoder1 = Input_encoder{end};
				    Ref_norm = (Ref.decs-repmat(Lower,size(Ref.decs,1),1))./repmat(Upper-Lower,size(Ref.decs,1),1);
				    Ref_encoder = net.forwardEncoder(Ref_norm);
                    Ref_encoder1 = Ref_encoder{end};
                    Next=SurrogateAssistedSelection_CSIII(Problem,net,p0,p1,Ref_encoder1,Input_encoder1,gmax,tr);
                    if ~isempty(Next)
    					Next_decoder = net.forwardDecoderFromHidden(Next);
                        Next = Next_decoder.*repmat(Upper-Lower,size(Next,1),1) + repmat(Lower,size(Next,1),1);
                        Arc = [Arc,Problem.Evaluation(Next)];
                        Population = EnvironmentalSelection_Clustering(Arc,Problem.N,Problem.N);
                    end
                else
                    Next=SurrogateAssistedSelection_CSII(Problem,net,p0,p1,Ref,Population.decs,gmax,tr);
                    if ~isempty(Next)
                        Arc = [Arc,Problem.Evaluation(Next)];
                        Population = EnvironmentalSelection_Clustering(Arc,Problem.N,Problem.N);
                    end
                end
				
            end   
                
        end
    end
end