function Next = SurrogateAssistedSelection_CSIII(Problem,net,p0,p1,Ref,Input,wmax,tr)
    Parent = [Input;Ref];
    Next  = ReproductionGA(Problem,Parent);
    Label = net.forwardClassifierFromHidden(Next);
    a     = tr;
    b     = 1 - tr;
    i     = 0;
    if p0<0.4 || (p1<a&&p0<b)
        while i < wmax
            [~,index] = sort(Label,'descend');
            [ab,~]=size(Ref);
            Input     = Next(index(1:ab),:);
            Next      = ReproductionGA(Problem,[Input;Ref]);
            Label = net.forwardClassifierFromHidden(Next);
            i = i+size(Next,1);
        end
        
        if isempty(Next(Label>0.9,:))&&rand<0.5
            [aa,~]=size(Next);
            randindex = randperm(aa);
            Next = Next(randindex(1),:);
        else
            Next = Next(Label>0.9,:);
        end
    elseif p0>b && p1<a % Randomly select one to avoid loop
        [ab,~]=size(Next);
        randindex = randperm(ab);
        Next = Next(randindex(1),:);
    elseif p1 > b
        while i<wmax
            [~,index] = sort(Label);
            [ab,~]=size(Ref);
            Input     = Next(index(1:ab),:);
            Next      = ReproductionGA(Problem,[Input;Ref]);
            Label = net.forwardClassifierFromHidden(Next);
            i = i+size(Next,1);
        end
        
        if isempty(Next(Label<0.1,:))&&rand<0.5
            [aa,~]=size(Next);
            randindex = randperm(aa);
            Next = Next(randindex(1),:);
        else
            Next = Next(Label<0.1,:);
        end
    else
        Next = Next(randi(end),:);
    end
end

function Offspring = ReproductionGA(Problem,Parent)
    [~,D] = size(Parent);
    Lower = zeros(1,D);
	Upper = ones(1,D);

    Parent1   = Parent(1:floor(end/2),:);
    Parent2   = Parent(floor(end/2)+1:floor(end/2)*2,:);

    Offspring = zeros(2*size(Parent1,1),size(Parent1,2));
    %% Simulated binary crossover
    Offspring = SBX(Parent1,Parent2);
	
	%% Polynomial mutation
    Offspring = RealMutation(Offspring,Lower,Upper);
end

function Offspring = RealMutation(Offspring,Lower,Upper)
% Polynomial mutation
    disM  = 5;
    [N,D] = size(Offspring);
    Lower = repmat(Lower,N,1);
    Upper = repmat(Upper,N,1);
    Site  = rand(N,D) < 1/D;
    mu    = rand(N,D);
    temp  = Site & mu<=0.5;
    Offspring       = min(max(Offspring,Lower),Upper);
    Offspring(temp) = Offspring(temp)+(Upper(temp)-Lower(temp)).*((2.*mu(temp)+(1-2.*mu(temp)).*...
                      (1-(Offspring(temp)-Lower(temp))./(Upper(temp)-Lower(temp))).^(disM+1)).^(1/(disM+1))-1);
    temp = Site & mu>0.5; 
    Offspring(temp) = Offspring(temp)+(Upper(temp)-Lower(temp)).*(1-(2.*(1-mu(temp))+2.*(mu(temp)-0.5).*...
                      (1-(Upper(temp)-Offspring(temp))./(Upper(temp)-Lower(temp))).^(disM+1)).^(1/(disM+1)));
    Offspring       = min(max(Offspring,Lower),Upper);
end

function Offspring = SBX(Parent1,Parent2)
% Genetic operators for real variables
    [proC,disC] = deal(1,15);
    %% Simulated binary crossover
    [N,D] = size(Parent1);
    beta  = zeros(N,D);
    mu    = rand(N,D);
    beta(mu<=0.5) = (2*mu(mu<=0.5)).^(1/(disC+1));
    beta(mu>0.5)  = (2-2*mu(mu>0.5)).^(-1/(disC+1));
    beta = beta.*(-1).^randi([0,1],N,D);
    beta(rand(N,D)<0.5) = 1;
    beta(repmat(rand(N,1)>proC,1,D)) = 1;
    Offspring = (Parent1+Parent2)/2+beta.*(Parent1-Parent2)/2;
end

