function Next = RSurrogateAssistedSelectionII(Problem,Ref,Input,wmax,Smodel,afnn)

    Lower = Problem.lower;
    Upper = Problem.upper;
    epoch = 10;

    Next = OperatorGA(Problem,[Input;Ref.decs],{1,15,1,5});
    Next_norm = (Next-repmat(Lower,size(Next,1),1))./repmat(Upper-Lower,size(Next,1),1);
    afnn.train_encoder_decoder_v2(Next_norm, Next_norm, 0.05, epoch);
    [~,Next_encoder,~] = afnn.forwardDecoder(Next_norm);
    Next_encoder = Next_encoder{end};

    i    = 0;
    while i < wmax
        [soerted_index,~]= model_select(Smodel,Next_encoder);
        Input = Next(soerted_index(1:length(Ref)),:);
        Next  = OperatorGA(Problem,[Input;Ref.decs],{1,15,1,5});
        Next_norm = (Next-repmat(Lower,size(Next,1),1))./repmat(Upper-Lower,size(Next,1),1);
        afnn.train_encoder_decoder_v2(Next_norm, Next_norm, 0.05, epoch);
        [~,Next_encoder,~] = afnn.forwardDecoder(Next_norm);
        Next_encoder = Next_encoder{end};
        i     = i + size(Next,1);
    end
    [~,scores] = model_select(Smodel,Next_encoder);
    if sum(scores>3.9) < 4
        [~,ind] = sort(scores,'descend');
        Next    = Next(ind(1:4),:); 
    else
        Next = Next(scores>3.9,:);
    end
end

function [ind,scores] = model_select(Smodel,Next)
    model_x = Smodel.X;    
    C1_data = model_x(Smodel.Y ==1,:);
    C2_data = model_x(Smodel.Y ~=1,:);

    C1_num   = size(C1_data,1);
    C2_num   = size(C2_data,1);
    Next_num = size(Next,1);

    scores = zeros(Next_num,2);
    
    all_testdata = zeros(2*(C1_num+C2_num)*Next_num,2*size(C1_data,2));
    for i = 1 : size(Next,1)
        original = (i-1)*2*(C1_num+C2_num);
        Xi       = repmat(Next(i,:),size(C1_data,1),1);
        all_testdata(original+1:original+C1_num,:)          = [C1_data,Xi];  %C1_Xi
        all_testdata(original+1+C1_num:original+C1_num*2,:) = [Xi,C1_data]; %Xi_C1
        
        Xi = repmat(Next(i,:),size(C2_data,1),1);
        all_testdata(original+1+C1_num*2:original+C1_num*2+C2_num,:)          = [C2_data,Xi]; %C2_Xi
        all_testdata(original+1+C2_num+C1_num*2:original+C2_num*2+C1_num*2,:) = [Xi,C2_data];%Xi_C2
    end
    
    TestIn_nor = mapminmax('apply',all_testdata',Smodel.mp_struct)';
    pre_out = Smodel.net(TestIn_nor')';  
    
    for i = 1 : size(Next,1)
        C_SCORE    = zeros(1,2);
        original   = (i-1)*2*(C1_num+C2_num);
        pre_C1Xi   = sum(pre_out(original+1:original+C1_num,:),1)./C1_num;
        C_SCORE(1) = C_SCORE(1) + pre_C1Xi(2)+pre_C1Xi(3);   
        C_SCORE(2) = C_SCORE(2) + pre_C1Xi(1);               
        
        pre_XiC1   = sum(pre_out(original+1+C1_num:original+C1_num*2,:),1)./C1_num;
        C_SCORE(1) = C_SCORE(1) + pre_XiC1(2) + pre_XiC1(1);  
        C_SCORE(2) = C_SCORE(2) + pre_XiC1(3);                 
        
        pre_C2Xi   = sum(pre_out(original+1+C1_num*2:original+C1_num*2+C2_num,:),1)./C2_num;
        C_SCORE(1) = C_SCORE(1) + pre_C2Xi(3);
        C_SCORE(2) = C_SCORE(2) + pre_C2Xi(2) + pre_C2Xi(1);
        
        pre_XiC2   = sum(pre_out(original+1+C2_num+C1_num*2:original+C2_num*2+C1_num*2,:),1)./C2_num;
        C_SCORE(1) = C_SCORE(1) + pre_XiC2(1);
        C_SCORE(2) = C_SCORE(2) + pre_XiC2(2) + pre_XiC2(3);
        
        scores(i) = C_SCORE(1)-C_SCORE(2);
    end      
    [~,ind] = sort(scores,'descend');  
end