function Next = SurrogateAssistedSelection_CSII(Problem,net,p0,p1,Ref,Input,wmax,tr)
    epoch = 10;
    Lower = Problem.lower;
    Upper = Problem.upper;

    Next  = OperatorGA(Problem,[Input;Ref.decs],{1,15,1,5});
    Next_norm = (Next-repmat(Lower,size(Next,1),1))./repmat(Upper-Lower,size(Next,1),1);
    
    net.train_shared_decoder_v2(Next_norm, Next_norm, 0.01, epoch);
    
    Label = net.predictClassifier(Next_norm);
    a     = tr;
    b     = 1 - tr;
    i     = 0;
    if p0<0.4 || (p1<a&&p0<b)
        while i < wmax
            [~,index] = sort(Label,'descend');
            [ab,~]=size(Ref);
            Input     = Next(index(1:ab),:);
            Next      = OperatorGA(Problem,[Input;Ref.decs],{1,15,1,5});
            Next_norm = (Next-repmat(Lower,size(Next,1),1))./repmat(Upper-Lower,size(Next,1),1);
            net.train_shared_decoder_v2(Next_norm, Next_norm, 0.01, epoch);
            Label = net.predictClassifier(Next_norm);
            i = i+size(Next,1);
        end
        
        if isempty(Next(Label>0.9,:))&&rand<0.5
            [aa,~]=size(Next);
            randindex = randperm(aa);
            Next = Next(randindex(1),:);
        else
            Next = Next(Label>0.9,:);
        end
    elseif p0>b && p1<a % Randomly select one to avoid loop
        [aa,~]=size(Next);
        randindex = randperm(aa);
        Next = Next(randindex(1),:);
    elseif p1 > b
        while i<wmax
            [~,index] = sort(Label);
            [aa,~]=size(Ref);
            Input     = Next(index(1:aa),:);
            Next      = OperatorGA(Problem,[Input;Ref.decs],{1,15,1,5});
            Next_norm = (Next-repmat(Lower,size(Next,1),1))./repmat(Upper-Lower,size(Next,1),1); 
            net.train_shared_decoder_v2(Next_norm, Next_norm, 0.01, epoch);
            Label = net.predictClassifier(Next_norm);
            i = i+size(Next,1);
        end
        
        if isempty(Next(Label<0.1,:))&&rand<0.5
            [aa,~]=size(Next);
            randindex = randperm(aa);
            Next = Next(randindex(1),:);
        else
            Next = Next(Label<0.1,:);
        end
    else
        Next = Next(randi(end),:);
    end
end