classdef FREMO < ALGORITHM
    methods
        function main(Algorithm,Problem)
            %% Parameterr setting
            [k,gmax] = Algorithm.ParameterSet(6,3000);

            %% Initalize the population by Latin hypercube sampling
            if Problem.D <= 10
                N = 11*Problem.D-1;
            else
                N = 100;
            end
            PopDec     = UniformPoint(N,Problem.D,'Latin');
            Population = Problem.Evaluation(repmat(Problem.upper-Problem.lower,N,1).*PopDec+repmat(Problem.lower,N,1));
            Archive    = Population;

            learning_rate = 0.01;
            momentum = 0.9;
            n_inputs = Problem.D;
            n_outputs_decoder = Problem.D;
            n_hidden_layers_encoder = 1;
            n_hidden_units_encoder = min(ceil(Problem.D/2),5);
            %n_hidden_units_encoder = ceil(1.5*Problem.D);
            n_hidden_layers_decoder = 0;
            n_hidden_units_decoder = 10;

            Lower = Problem.lower;
            Upper = Problem.upper;

            %% Optimization
            while Algorithm.NotTerminated(Archive)
                % Select reference solutions and preprocess the data
                Ref    = EnvironmentalSelection_Clustering(Population,Problem.N,k);
                Input     = Population.decs; 

                afnn = AFNN_Autoencoder_REMOIV(n_inputs, n_outputs_decoder, ...
                            n_hidden_layers_encoder, n_hidden_layers_decoder, ...
                            n_hidden_units_encoder, n_hidden_units_decoder, ...
                            learning_rate, momentum);
                Input_norm = (Input-repmat(Lower,size(Input,1),1))./repmat(Upper-Lower,size(Input,1),1);
                afnn.train_encoder_decoder_v2(Input_norm, Input_norm, 0.01, 500);

                Catalog   = GetOutput_PBI(Population.objs,Ref.objs);

                [~,Input_encoder,~] = afnn.forwardDecoder(Input_norm);
                Input_encoder = Input_encoder{end};

                [XXs,YYs] = GetRelationPairs(Input_encoder,Catalog);
                [TrainIn,TrainOut,TestIn,TestOut] = DataProcess(XXs,YYs);
                
                xDim = size(TrainIn,2);
                
                % Train relation model
                [TrainIn_nor,TrainIn_struct] = mapminmax(TrainIn');
                TrainIn_nor     = TrainIn_nor';
                TrainOut_onehot = onehotconv(TrainOut,1);
                net = patternnet([ceil(xDim*1.5),xDim*1,ceil(xDim/2)]);
                net.trainParam.showWindow =0;
                net        = train(net,TrainIn_nor',TrainOut_onehot');
                TestIn_nor = mapminmax('apply',TestIn',TrainIn_struct)';
                TestPre    = onehotconv(net(TestIn_nor')',2);             
                p_err      = sum(TestPre ~= TestOut)/size(TestPre,1);
                Smodel.X   = Input_encoder;
                Smodel.Y   = Catalog;
                Smodel.mp_struct = TrainIn_struct;
                Smodel.net       = net;
                Smodel.p_err     = p_err;
                
                if rand < 0.95
                    Ref_norm = (Ref.decs-repmat(Lower,size(Ref.decs,1),1))./repmat(Upper-Lower,size(Ref.decs,1),1);
    				[~,Ref_encoder,~] = afnn.forwardDecoder(Ref_norm);
                    Ref_encoder1 = Ref_encoder{end};
                    Next = RSurrogateAssistedSelectionIII(Ref_encoder1,Input_encoder,gmax,Smodel);
                    if ~isempty(Next)
                        Next_decoder = afnn.forwardDecoderFromHidden(Next);
                        Next = Next_decoder.*repmat(Upper-Lower,size(Next,1),1) + repmat(Lower,size(Next,1),1);
                        Archive = [Archive,Problem.Evaluation(Next)];
                    end
                    Population = EnvironmentalSelection_Clustering(Archive,Problem.N,Problem.N);
                else
                    Next = RSurrogateAssistedSelectionII(Problem, Ref,Population.decs,gmax,Smodel,afnn);
                    if ~isempty(Next)
                        Archive = [Archive,Problem.Evaluation(Next)];
                    end
                    Population = EnvironmentalSelection_Clustering(Archive,Problem.N,Problem.N);
                end
            end
        end
	end
end