#!/bin/bash

if [[ $1 == 'train' ]]; then
    echo 'Run training (DEQ-Transformer Hyper)...'
    python train_hyper.py \
        --cuda \
        --data ./data/wikitext-103/ \
        --dataset wt103 \
        --adaptive \
        --div_val 4 \
        --n_layer 2 \
        --eval_n_layer 24 \
        --d_embed 700 \
        --d_model 700 \
        --n_head 10 \
        --d_head 70 \
        --d_inner 48000 \
        --dropout 0.05 \
        --dropatt 0.0 \
        --optim Adam \
        --lr 0.00025 \
        --warmup_step 0 \
        --pretrain_steps 0 \
        --eval-interval 500 \
        --max_step 5000 \
        --tgt_len 60 \
        --mem_len 400 \
        --eval_tgt_len 150 \
        --wnorm \
        --solver anderson \
        --stop_mode rel \
        --f_thres 10 \
        --batch_size 16 \
        --gpu0_bsz 8 \
        --m 5 \
        ${@:2}
elif [[ $1 == 'eval' ]]; then
    echo 'Not supported yet'
else
    echo 'unknown argment 1'
fi