import json
import os
import argparse
from ARCA import *
from game24 import Game24Task
from models import *
from outcomes import print_outcomes

if __name__ == "__main__":
    task = Game24Task()
    parser = argparse.ArgumentParser(description='Game24 dataset')

    parser.add_argument('--func', type=str, default='ARCA', help='Function to execute')
    args = parser.parse_args()
    print(args)
    logs = []
    file = f"logs/{args.func}/start{args.begin_task}_end{args.end_task}_select{args.n_select_sample}_evaluate{args.n_evaluate_time}.json"
    os.makedirs(os.path.dirname(file), exist_ok=True)
    count = 0
    for i in range(args.begin_task, args.end_task):
        if args.func == 'ARCA':
            answer, info = solve(args, task, idx=i, to_print=False)
        if (answer):
            count += 1
        print("Answers:", answer)
        print('Count', count)
        info.update({"idx": i+1, "ys": answer, "usage_so_far": gpt_usage()})
        logs.append(info)
        with open(file, "w") as f1:
            json.dump(logs, f1, indent=4)
        print_outcomes(file)

