#!/bin/bash
# "0,1,2,3" "4,5,6,7"
export CUDA_VISIBLE_DEVICES="0,1,2,3"
export MASTER_PORT=5002


exp_name='LoT_llama_inference'
prefix="LoT_llama_inference"
dataset='gsm8k'
num_fewshot=8
gpu=0
seed=0
model='llama'
pretrained='your ckpt path'


if [ ! -d "logs/${exp_name}" ]; then
    mkdir -p logs/${exp_name}
fi
log_filename=logs/${exp_name}/${prefix}_${model}_${dataset}_shot${num_fewshot}_seed${seed}.log
while true; do
    log_filename=logs/${exp_name}/${prefix}_${model}_${dataset}_shot${num_fewshot}_seed${seed}.log
    if [ ! -f "${log_filename}" ]; then
        break
    fi
    seed=$((seed + 1))
done

nohup accelerate launch --main_process_port ${MASTER_PORT} -m lm_eval \
    --model hf \
    --model_args pretrained=${pretrained},max_length=2048  \
    --task ${dataset} \
    --num_fewshot ${num_fewshot} \
    --gen_kwargs top_p=1,temperature=0 \
    --batch_size 8 \
    > ${log_filename} 2>&1 &
