#!/bin/bash
prefix='LoT_ResNet'
teacher_network='resnet18'
student_network='resnet18'
dataset='cifar100'
detach=1
optimizer='sgd'
lr=0.02
weight_decay=0.0001
epochs=30
T=1.5
alpha=1
student_steps_ratio=1
sim_update=1
warm_up=3
downstream_mapping='linear_probing'
seed=0
gpu=0
batch_size=256
experiment_name=${teacher_network}_${student_network}_${dataset}_aplha${alpha}_N${student_steps_ratio}_${optimizer}_lr${lr}_decay${weight_decay}_epochs${epochs}_warmup${warm_up}_${downstream_mapping}_T${T}_btz${batch_size}_seed${seed}_gpu${gpu}
log_folder_name=logs/${prefix}_${dataset}
if [ ! -d ${log_folder_name} ]; then
    mkdir -p ${log_folder_name}
fi
ckpt_folder_name=ckpt/${prefix}_${dataset}
if [ ! -d ${ckpt_folder_name} ]; then
    mkdir -p ${ckpt_folder_name}
fi
save=${ckpt_folder_name}/${experiment_name}

log_filename=${log_folder_name}/${experiment_name}.log
nohup python -u trainer/image_classification.py \
    --exp_name ${experiment_name} \
    --teacher_network ${teacher_network} \
    --student_network "${student_network}" \
    --dataset ${dataset} \
    --epochs ${epochs} \
    --lr ${lr} \
    --weight_decay ${weight_decay} \
    --seed ${seed} \
    --gpu ${gpu} \
    --alpha ${alpha} \
    --T ${T} \
    --student_steps_ratio ${student_steps_ratio} \
    --optimizer ${optimizer} \
    --sim_update ${sim_update} \
    --warm_up ${warm_up} \
    --downstream_mapping ${downstream_mapping} \
    --save ${save} \
    --batch_size ${batch_size} \
> ${log_filename} 2>&1 &