import pandas as pd
import torch_geometric.datasets as datasets

dataset_info = [
    ("KarateClub", datasets.KarateClub, []),
    (
        "TUDataset",
        datasets.TUDataset,
        ["MUTAG", "IMDB-BINARY", "REDDIT-BINARY", "PROTEINS"],
    ),
    (
        "GNNBenchmarkDataset",
        datasets.GNNBenchmarkDataset,
        ["CIFAR10", "MNIST"],
    ),
    (
        "Planetoid",
        datasets.Planetoid,
        ["Cora", "CiteSeer", "PubMed"],
    ),
    ("NELL", datasets.NELL, []),
    (
        "CitationFull",
        datasets.CitationFull,
        ["Cora", "CiteSeer", "PubMed"],
    ),
    ("Coauthor", datasets.Coauthor, ["CS", "Physics"]),
    (
        "Amazon",
        datasets.Amazon,
        ["Computers", "Photo"],
    ),
    ("PPI", datasets.PPI, []),
    ("Reddit", datasets.Reddit, []),
    ("Reddit2", datasets.Reddit2, []),
    ("Flickr", datasets.Flickr, []),
    ("Yelp", datasets.Yelp, []),
    ("AmazonProducts", datasets.AmazonProducts, []),
    ("QM7b", datasets.QM7b, []),
    ("QM9", datasets.QM9, []),
    ("MD17", datasets.MD17, []),
    ("ZINC", datasets.ZINC, []),
    ("AQSOL", datasets.AQSOL, []),
    ("MoleculeNet", datasets.MoleculeNet, []),
    ("PCQM4Mv2", datasets.PCQM4Mv2, []),
    (
        "Entities",
        datasets.Entities,
        ["AIFB", "MUTAG", "BGS", "AM"],
    ),
    (
        "RelLinkPredDataset",
        datasets.RelLinkPredDataset,
        ["FB15k", "WN18", "FB15k-237", "WN18RR"],
    ),
    ("GEDDataset", datasets.GEDDataset, []),
    ("AttributedGraphDataset", datasets.AttributedGraphDataset, []),
    ("MNISTSuperpixels", datasets.MNISTSuperpixels, []),
    ("FAUST", datasets.FAUST, []),
    ("DynamicFAUST", datasets.DynamicFAUST, []),
    ("ShapeNet", datasets.ShapeNet, []),
    (
        "ModelNet",
        datasets.ModelNet,
        ["ModelNet10", "ModelNet40"],
    ),
    ("CoMA", datasets.CoMA, []),
    ("SHREC2016", datasets.SHREC2016, []),
    ("TOSCA", datasets.TOSCA, []),
    ("PCPNetDataset", datasets.PCPNetDataset, []),
    ("S3DIS", datasets.S3DIS, []),
    ("GeometricShapes", datasets.GeometricShapes, []),
    ("BitcoinOTC", datasets.BitcoinOTC, []),
    ("GDELTLite", datasets.GDELTLite, []),
    ("ICEWS18", datasets.ICEWS18, []),
    ("GDELT", datasets.GDELT, []),
    ("WILLOWObjectClass", datasets.WILLOWObjectClass, []),
    ("PascalVOCKeypoints", datasets.PascalVOCKeypoints, []),
    ("PascalPF", datasets.PascalPF, []),
    ("SNAPDataset", datasets.SNAPDataset, []),
    ("SuiteSparseMatrixCollection", datasets.SuiteSparseMatrixCollection, []),
    ("WordNet18", datasets.WordNet18, []),
    ("WordNet18RR", datasets.WordNet18RR, []),
    ("FB15k_237", datasets.FB15k_237, []),
    ("WikiCS", datasets.WikiCS, []),
    ("WebKB", datasets.WebKB, []),
    ("WikipediaNetwork", datasets.WikipediaNetwork, []),
    (
        "HeterophilousGraphDataset",
        datasets.HeterophilousGraphDataset,
        [
            "Roman-empire",
            "Amazon-ratings",
            "Minesweeper",
            "Tolokers",
            "Questions",
        ],
    ),
    ("Actor", datasets.Actor, []),
    ("UPFD", datasets.UPFD, []),
    ("GitHub", datasets.GitHub, []),
    ("FacebookPagePage", datasets.FacebookPagePage, []),
    ("LastFMAsia", datasets.LastFMAsia, []),
    ("DeezerEurope", datasets.DeezerEurope, []),
    ("GemsecDeezer", datasets.GemsecDeezer, []),
    ("Twitch", datasets.Twitch, []),
    ("Airports", datasets.Airports, []),
    ("LRGBDataset", datasets.LRGBDataset, []),
    ("MalNetTiny", datasets.MalNetTiny, []),
    ("OMDB", datasets.OMDB, []),
    ("PolBlogs", datasets.PolBlogs, []),
    ("EmailEUCore", datasets.EmailEUCore, []),
    ("LINKXDataset", datasets.LINKXDataset, []),
    ("EllipticBitcoinDataset", datasets.EllipticBitcoinDataset, []),
    (
        "EllipticBitcoinTemporalDataset",
        datasets.EllipticBitcoinTemporalDataset,
        [],
    ),
    ("DGraphFin", datasets.DGraphFin, []),
    ("HydroNet", datasets.HydroNet, []),
    ("AirfRANS", datasets.AirfRANS, []),
    ("JODIEDataset", datasets.JODIEDataset, []),
    ("Wikidata5M", datasets.Wikidata5M, []),
    ("MyketDataset", datasets.MyketDataset, []),
    ("BrcaTcga", datasets.BrcaTcga, []),
    ("NeuroGraphDataset", datasets.NeuroGraphDataset, []),
    ("WebQSPDataset", datasets.WebQSPDataset, []),
]

data_list = []

for name, dataset_class, sub_datasets in dataset_info:
    if sub_datasets:
        for sub_name in sub_datasets:
            try:
                dataset = dataset_class(
                    root=f"./data/{name}/{sub_name}", name=sub_name
                )
                graph = dataset[0]
                num_nodes = graph.num_nodes
                num_edges = graph.num_edges
                density = num_edges / num_nodes if num_nodes > 0 else 0
                data_list.append(
                    [f"{name}-{sub_name}", num_nodes, num_edges, density]
                )
            except Exception as e:
                print(f"Error loading {name}-{sub_name}: {e}")
    else:
        try:
            dataset = dataset_class(root=f"./data/{name}")
            graph = dataset[0]
            num_nodes = graph.num_nodes
            num_edges = graph.num_edges
            density = num_edges / num_nodes if num_nodes > 0 else 0
            data_list.append([name, num_nodes, num_edges, density])
        except Exception as e:
            print(f"Error loading {name}: {e}")

df = pd.DataFrame(
    data_list, columns=["Dataset", "Num Nodes", "Num Edges", "Density"]
)

output_file = "graph_datasets_info.xlsx"
df.to_excel(output_file, index=False)

print(f"Excel file saved as {output_file}")
