import torch
from torch_geometric.graphgym import cfg
from torch_geometric.graphgym.register import register_edge_encoder

# this code is used in the folliwing dataset
# PATTERN


@register_edge_encoder("DummyEdge")
class DummyEdgeEncoder(torch.nn.Module):
    def __init__(self, emb_dim):
        super().__init__()

        self.encoder = torch.nn.Embedding(
            num_embeddings=1, embedding_dim=emb_dim
        )
        # torch.nn.init.xavier_uniform_(self.encoder.weight.data)

    def forward(
        self,
        batch,
        cur_epoch=None,
        mpnn_th=None,
        msa_th=None,
        ffn_th=None,
        encoder_th=None,
        pred_th=None,
        global_th=None,
    ):

        if encoder_th is not None:
            threshold = encoder_th
        elif global_th is not None:
            threshold = global_th
        dummy_attr = batch.edge_index.new_zeros(batch.edge_index.shape[1])
        if cfg.slt.embedding is True:
            NotImplementedError
            batch.edge_attr = self.encoder(dummy_attr, threshold)
        else:
            self.encoder(dummy_attr)

        return batch
