import math


def exponential_function(x, lambd=6):
    return 1 - math.exp(-lambd * x)


def generate_values(initial_value, lambd=6, count=3):
    values = [initial_value]
    for _ in range(count - 1):
        next_value = exponential_function(values[-1], lambd)
        values.append(next_value)
    return values


initial_value = 0.5
result_values = generate_values(initial_value)

for i, value in enumerate(result_values):
    print(f"Value {i+1}: {value}")
