'''
Author: Derry derrylv@qq.com
Date: 2024-04-17 16:09:28
LastEditors: Derry derrylv@qq.com
LastEditTime: 2024-05-20 16:22:22
FilePath: /ord-notears/process.py
Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
'''

import pandas as pd
import ast

def parse_data(file_path):
    parsed_data = []
    try:
        with open(file_path, 'r') as file:
            lines = file.readlines()
            # Iterate over the lines in pairs
            for i in range(0, len(lines), 2):
                parameters_line = lines[i].strip()
                results_line = lines[i + 1].strip()
                
                # Split parameters and convert to appropriate types
                parameters = parameters_line.split(', ')
                parameters = [p.strip() for p in parameters]
                # Use ast.literal_eval to safely evaluate the string containing Python literals
                results = ast.literal_eval(results_line)
                
                # Create a dictionary for parameters
                param_dict = {
                    'd': str(parameters[0]),
                    'n': int(parameters[1]),
                    'linear': parameters[2] == 'True',
                    'used_data': int(parameters[3]),
                    'ord_num': str(parameters[4]),
                    'i': int(parameters[5]),
                    'j': int(parameters[6])
                }
                
                # Combine parameters and results into one dictionary
                combined_data = {**param_dict, **results}
                parsed_data.append(combined_data)
                
        # Convert the list of dictionaries to a DataFrame
        return pd.DataFrame(parsed_data)
    except Exception as e:
        print(f"An error occurred: {e}")
        return pd.DataFrame()  # Return an empty DataFrame in case of error
# Example usage:
file_path = f"res/sach_res.txt"
df = parse_data(file_path)

# result = df.groupby(['d', 'n', 'linear', 'used_data', 'ord_num']).agg({
#     'shd': ['mean', 'std'],
#     'f1': ['mean', 'std'],
#     'time': ['mean', 'std']
# })

result = df

print(result)
result.to_csv(f"res/sach_res.csv")