
# Supplementary Material: Towards Effective MLLM Jailbreaking through Balanced On-topicness and OOD-Intensity



![model_figure](./assets/method_overview.png)

## Abstract

Multimodal large language models (MLLMs) are widely used in vision-language reasoning tasks. However, their vulnerability to adversarial prompts remains a serious concern, as safety mechanisms often fail to prevent the generation of harmful outputs. Although recent jailbreak strategies report high success rates, many responses classified as ``successful'' are actually benign, vague, or unrelated to the intended malicious goal. This mismatch suggests that current evaluation standards may overestimate the effectiveness of such attacks. To address this issue, we introduce a four-axis evaluation framework that considers input on-topicness, input out-of-distribution (OOD) intensity, output harmfulness, and output refusal rate. This framework identifies truly effective jailbreaks. In a substantial empirical study, we reveal a structural trade-off: highly on-topic prompts are frequently blocked by safety filters, whereas those that are too OOD often evade detection but fail to produce harmful content. However, prompts that balance relevance and novelty are more likely to evade filters and trigger dangerous output. Building on this insight, we develop a recursive rewriting strategy called Balanced Structural Decomposition (BSD). The approach restructures malicious prompts into semantically aligned sub-tasks, while introducing subtle OOD signals and visual cues that make the inputs harder to detect. BSD was tested across 13 commercial and open-source MLLMs, where it consistently led to higher attack success rates, more harmful outputs, and fewer refusals. Compared to previous methods, it improves success rates by $67\%$ and harmfulness by $21\%$, revealing a previously underappreciated weakness in current multimodal safety systems.





## Model and Data Preparation

### Set API keys and `HF_Home`
```
export GEMINI_API_KEY=your_api_key
export ANTHROPIC_API_KEY=your_api_key
export OPENAI_API_KEY=your_api_key
export HF_HOME=/path/to/hf_home
```

### External Models 

- Embedding Model (Used in CS-DJ): [clip-ViT-L-14](https://huggingface.co/sentence-transformers/clip-ViT-L-14)
- Decomposition Model: [Qwen2.5-7B](https://huggingface.co/Qwen/Qwen2.5-7B)
- Evaluation Model: [Beaver-Dam-7b](https://huggingface.co/PKU-Alignment/beaver-dam-7b)
- Text-to-Image Model: [FLUX.1-schnell](https://huggingface.co/black-forest-labs/FLUX.1-schnell)
- Victim Model: [InternVL3](https://huggingface.co/collections/OpenGVLab/internvl3-67f7f690be79c2fe9d74fe9d)
- Victim Model: [Qwen2.5-VL](https://huggingface.co/collections/Qwen/qwen25-vl-6795ffac22b334a837c0f9a5)

### Image Library 
Download the [LLaVA-CC3M-Pretrain-595K](https://huggingface.co/datasets/liuhaotian/LLaVA-CC3M-Pretrain-595K) dataset and store images in the `../LLaVA-CC3M-Pretrain-595K/` directory.

Or you can set your own directory in `scripts/config.py`:
```
parser.add_argument("--src_dir", type=str, default='../LLaVA-CC3M-Pretrain-595K/', help="Image directory")
```

## Dependencies
We have tested our code in Python 3.10
```bash
pip install -r requirements.txt
```

## Usage


### Set Up
Configure the retrieval random  `seed` (e.g., `2025`), `image count` (e.g., `10000`), `object model` (We support `qwen2.5-vl-7b`, `qwen2.5-vl-32b`, `claude-sonnet-4`,`claude-haiku-3.5`,`gpt-4.1`,`gpt-4o-mini`, `gpt-4o`, `gpt-4.1-mini`, `internvl3-8b`, `internvl3-14b`, `internvl3-38b`, `gemini-2.5-flash`, `gemini-2.5-pro`), `openai_api_key`, `anthropic_api_key`, and `gemini_api_key` in the `config.py` file.

### Reproduce our results

```bash
bash run.sh
```

## Related Projects

- [Hades](https://github.com/RUCAIBox/HADES)
- [BeaverTails](https://github.com/PKU-Alignment/beavertails)
- [CS-DJ](https://github.com/TeamPigeonLab/CS-DJ/tree/main)
