import os
import pickle
import csv
from collections import defaultdict
import time
from typing import Dict, DefaultDict, List, Any, Tuple, Optional

from initialization.setup_inputs import create_agents
from main.implement_SDA import implement_SDA
from utils.count_match import count_match

def create_csv_data(
        dispersion: float,
        alpha: float,
        max_try: int,
        list_for_fnum: List[int],
    ):

    if dispersion == 1.0:
        dispersion = 1
    if dispersion == 0.0:
        dispersion = 0 

    dirname_outcome_csv = 'experiments/synthetic_data/csv_data'
    if not os.path.isdir(dirname_outcome_csv):
        os.makedirs(dirname_outcome_csv)
    
    filename_outcome_csv = f'experiments/synthetic_data/csv_data/artificial_data_max_try_{max_try}_phi_{dispersion}_alpha_{alpha}.csv'

    if not os.path.isfile(filename_outcome_csv): 

        suc_num_SDA = []
        match_num_SDA = []
        time_num_SDA = []
        children_num = []
        suc_list_SDA = []
        data_pkl_list = []


        for i in range(len(list_for_fnum)):

            fnum = list_for_fnum[i]

            match_num_each = []
            children_num_each = []
            time_num_each = []
            suc_num_each = 0
            suc_list_SDA_each = []
            
            for r in range(max_try):

                dirsname = f'experiments/synthetic_data/data_pkl_paper_phi_{dispersion}_alpha_{alpha}'
                filename = f'experiments/synthetic_data/data_pkl_paper_phi_{dispersion}_alpha_{alpha}/artificial_data_fnum_{fnum}_{r}_phi_{dispersion}_alpha_{alpha}.pkl'

                try:
                    assert os.path.isdir(dirsname) and os.path.isfile(filename)
                except AssertionError as err:
                    print('AssertionError :', err)

                children_dic, daycares_dic, families_dic = pickle.load(open(filename, "rb"))


                data_pkl_list.append(filename)
                # print("data = ", filename)
                children, daycares, families = create_agents(children_dic, daycares_dic, families_dic)

                time_sta = time.time()    
                pi, succeed = implement_SDA(children, daycares, families)
                time_end = time.time()        
                tim = time_end - time_sta  

                if succeed:
                    suc_num_each +=1
                    suc_list_SDA_each.append(1)
                else:
                    # print("Algorithm fails.")
                    suc_list_SDA_each.append(0)

                dic, num_of_match_chil = count_match(children, families, daycares)

                children_num_each.append(len(children_dic))
                time_num_each.append(tim)
                match_num_each.append(num_of_match_chil)

            match_num_SDA.append(match_num_each)
            children_num.append(children_num_each)
            time_num_SDA.append(time_num_each)

            suc_num_SDA.append(suc_num_each)

            suc_list_SDA.append(suc_list_SDA_each)


        # Next, CP

        share_bool = False
        bp_num=0
        solver_time=1000 
        exclude_bool=True
        search_depth=0

        time_num_CP = []
        suc_num_CP = []
        match_num_CP = []
        suc_list_CP = []


        for i in range(len(list_for_fnum)):

            fnum = list_for_fnum[i]

            match_num_each = []
            time_num_each = []
            suc_list_CP_each = []
            suc_num_each = 0
            
            for r in range(max_try):

                # ファイル名を作成
                filename = f'experiments/synthetic_data/data_pkl_paper_phi_{dispersion}_alpha_{alpha}/artificial_data_fnum_{fnum}_{r}_phi_{dispersion}_alpha_{alpha}.pkl'

                
                children_dic, daycares_dic, families_dic = pickle.load(open(filename, "rb"))
                children, daycares, families = create_agents(children_dic, daycares_dic, families_dic)


                print("data = ", filename)
                time_sta = time.time()     
                solver_status, match_num_int, outcome_children_dic, outcome_fp, children, daycares, families = CP(children_dic, daycares_dic, families_dic, share_bool, bp_num, solver_time, exclude_bool, search_depth)
                time_end = time.time()        
                tim = time_end - time_sta  

                if solver_status != "INFEASIBLE":
                    suc_num_each +=1
                    match_num_each.append(match_num_int)
                    suc_list_CP_each.append(1)
                else:
                    match_num_each.append(0)
                    suc_list_CP_each.append(0)
                time_num_each.append(tim)

            match_num_CP.append(match_num_each)
            time_num_CP.append(time_num_each)
            suc_num_CP.append(suc_num_each)

            suc_list_CP.append(suc_list_CP_each)



        if not os.path.isdir('experiments/synthetic_data/csv_data'):
            os.makedirs('experiments/synthetic_data/csv_data')
        
        filename_outcome_csv = f'experiments/synthetic_data/csv_data/artificial_data_max_try_{max_try}_phi_{dispersion}_alpha_{alpha}.csv'
        with open(filename_outcome_csv, 'w') as f:
            writer = csv.writer(f)
            writer.writerow(["fnum", "run", "children_num", "match_num_SDA", "time_num_SDA", "success_SDA", "match_num_CP", "time_num_CP", "success_CP"] )
            for i in range(len(list_for_fnum)):
                for r in range(max_try):
                    writer.writerow(
                        [
                            list_for_fnum[i], 
                            r, 
                            children_num[i][r], 
                            match_num_SDA[i][r], 
                            time_num_SDA[i][r], 
                            suc_list_SDA[i][r], 
                            match_num_CP[i][r], 
                            time_num_CP[i][r], 
                            suc_list_CP[i][r] 
                        ]
                    )
